use std::{env, fs};
use std::path::Path;

use regex::Regex;

pub fn get_ticket_id() -> Result<String, String> {
    let current_dir = env::current_dir().unwrap();
    let current_dir = current_dir.as_os_str().to_str().unwrap();

    let git_file_path = format!("{}{}", current_dir, "/.git/HEAD");

    let has_repo = Path::new(git_file_path.as_str()).exists();

    if !has_repo {
        return Err(String::from("not a git repo."));
    }

    let git_file_content = fs::read_to_string(git_file_path).expect("no file.");

    let ticket_regex = Regex::new(r"([a-zA-Z]+-\d+)").unwrap();

    let captures = ticket_regex.captures(&git_file_content);

    let ticket_id = match captures {
        Some(captures) => captures.get(1).map_or(Ok(String::new()), |m| Ok(String::from(m.as_str()))),
        None => Err(String::from("ticket id can not be parsed.")),
    };

    return ticket_id;
}
