use std::{env, fs};
use std::io::{stdin, stdout, Write};
use std::ops::Add;
use std::path::Path;
use std::process::{Command};

use regex::Regex;

fn main() {
    let current_dir = env::current_dir().unwrap();
    let current_dir = current_dir.as_os_str().to_str().unwrap();

    let git_file_path = format!("{}{}", current_dir, "/.git/HEAD");

    let has_repo = Path::new(git_file_path.as_str()).exists();

    if !has_repo {
        return eprintln!("not a git repo");
    }

    let git_file_content = fs::read_to_string(git_file_path).expect("no file");

    let ticket_regex = Regex::new(r"([a-zA-Z]+-\d+)").unwrap();

    let captures = ticket_regex.captures(&git_file_content);

    let ticket_id = match captures {
        Some(captures) => captures.get(1).map_or("", |m| m.as_str()),
        None => "",
    };

    if ticket_id == "" {
        return eprintln!("not a ticket repo!");
    }

    println!("what is the commit message ?");

    print!(">{} ", ticket_id);

    stdout().flush().unwrap();

    let mut buffer = String::new();
    let stdin = stdin();

    stdin.read_line(&mut buffer).unwrap();

    let commit_message = ticket_id.to_string()
        .add(" ")
        .add(&buffer);

    println!("committing: {}", commit_message);

    let status = Command::new("/usr/bin/git")
        .arg("commit")
        .arg("-m")
        .arg(commit_message)
        .status()
        .unwrap();

    if status.success() {
        return println!("commit success!");
    }
}
