mod brush;
mod io;
mod pixel_color;
mod pixel_sort;
mod pixel_sort_brut;
mod pixel_sorting;
mod slim;
mod validator;

pub fn brush_bottom_to_top(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, min: i32, max: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    brush::bottom_to_top(io, proba, min, max)
}

pub fn brush_left_to_right(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, min: i32, max: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    brush::left_to_right(io, proba, min, max)
}

pub fn brush_right_to_left(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, min: i32, max: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    brush::right_to_left(io, proba, min, max)
}

pub fn brush_top_to_bottom(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, min: i32, max: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    brush::top_to_bottom(io, proba, min, max)
}

pub fn convert(in_img: &str, out_img: &str, force_ouput_overwrite: bool) {
    validator::files_presence(in_img, out_img, force_ouput_overwrite);
    let img = image::open(in_img).unwrap();

    img.save(out_img).unwrap();
}

pub fn slim_bottom_to_top_global(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, colors: Vec<&str>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::bottom_to_top_global(io, proba, colors)
}

pub fn slim_left_to_right_global(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, colors: Vec<&str>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::left_to_right_global(io, proba, colors)
}

pub fn slim_right_to_left_global(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, colors: Vec<&str>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::right_to_left_global(io, proba, colors)
}

pub fn slim_top_to_bottom_global(in_img: &str, out_img: &str, force_ouput_overwrite: bool, proba: i32, colors: Vec<&str>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::top_to_bottom_global(io, proba, colors)
}

pub fn slim_bottom_to_top_per_color(in_img: &str, out_img: &str, force_ouput_overwrite: bool, colors_proba: Vec<(&str, i32)>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::bottom_to_top_per_color(io, colors_proba)
}

pub fn slim_left_to_right_per_color(in_img: &str, out_img: &str, force_ouput_overwrite: bool, colors_proba: Vec<(&str, i32)>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::left_to_right_per_color(io, colors_proba)
}

pub fn slim_right_to_left_per_color(in_img: &str, out_img: &str, force_ouput_overwrite: bool, colors_proba: Vec<(&str, i32)>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::right_to_left_per_color(io, colors_proba)
}

pub fn slim_top_to_bottom_per_color(in_img: &str, out_img: &str, force_ouput_overwrite: bool, colors_proba: Vec<(&str, i32)>) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    slim::top_to_bottom_per_color(io, colors_proba)
}

pub fn sort_brut_bottom_to_top(in_img: &str, out_img: &str, force_ouput_overwrite: bool){
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort_brut::bottom_to_top(io)
}

pub fn sort_brut_left_to_right(in_img: &str, out_img: &str, force_ouput_overwrite: bool){
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort_brut::left_to_right(io)
}

pub fn sort_brut_right_to_left(in_img: &str, out_img: &str, force_ouput_overwrite: bool){
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort_brut::right_to_left(io)
}

pub fn sort_brut_top_to_bottom(in_img: &str, out_img: &str, force_ouput_overwrite: bool){
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort_brut::top_to_bottom(io)
}

pub fn sort_bottom_to_top(in_img: &str, out_img: &str, force_ouput_overwrite: bool, detection_type: i32,
                          detection_min: i32, detection_max: i32, multiple_range: bool, detection_min_2: i32,
                          detection_max_2: i32, sorting_by: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort::bottom_to_top(io, detection_type, detection_min, detection_max, multiple_range, detection_min_2, detection_max_2, sorting_by)
}

pub fn sort_left_to_right(in_img: &str, out_img: &str, force_ouput_overwrite: bool, detection_type: i32,
                          detection_min: i32, detection_max: i32, multiple_range: bool, detection_min_2: i32,
                          detection_max_2: i32, sorting_by: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort::left_to_right(io, detection_type, detection_min, detection_max, multiple_range, detection_min_2, detection_max_2, sorting_by)
}

pub fn sort_right_to_left(in_img: &str, out_img: &str, force_ouput_overwrite: bool, detection_type: i32,
                          detection_min: i32, detection_max: i32, multiple_range: bool, detection_min_2: i32,
                          detection_max_2: i32, sorting_by: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort::right_to_left(io, detection_type, detection_min, detection_max, multiple_range, detection_min_2, detection_max_2, sorting_by)
}

pub fn sort_top_to_bottom(in_img: &str, out_img: &str, force_ouput_overwrite: bool, detection_type: i32,
                          detection_min: i32, detection_max: i32, multiple_range: bool, detection_min_2: i32,
                          detection_max_2: i32, sorting_by: i32) {
    let io = io::build_io(in_img, out_img, force_ouput_overwrite);
    pixel_sort::top_to_bottom(io, detection_type, detection_min, detection_max, multiple_range, detection_min_2, detection_max_2, sorting_by)
}
