use arkham::{App, Command, Context, Opt};

fn main() {
    let _ = App::new()
        .name("Fibonacci App")
        .version("1.0")
        .long_desc("This app can be used to calculate fibonacci numbers")
        .command(
            Command::new("fib")
                .opt(
                    Opt::scalar("count")
                        .short("n")
                        .long("num")
                        .desc("The index of the fibonacci number to return"),
                )
                .short_desc("Calculates a fibonacci number")
                .handler(fibonacci_handler),
        )
        .run()
        .unwrap();
}

fn fibonacci_handler(_app: &App, ctx: &Context, _args: &[String]) {
    let v = fibonacci(
        ctx.get_string("count")
            .unwrap_or_else(|| "1".to_string())
            .parse()
            .unwrap_or(1),
    );
    println!("Value is: {}", v);
}

fn fibonacci(n: u32) -> u32 {
    match n {
        0 => 1,
        1 => 1,
        _ => fibonacci(n - 1) + fibonacci(n - 2),
    }
}
