use arkham::{App, Command, Opt};
use criterion::{criterion_group, criterion_main, Criterion};

fn parse_args(c: &mut Criterion) {
    c.bench_function("parse_args", |b| {
        let args = vec![
            "--user".into(),
            "joe".into(),
            "--config".into(),
            "c.json".into(),
            "thing".into(),
        ];
        let mut app = App::new()
            .opt(Opt::scalar("user").short("u").long("user"))
            .command(
                Command::new("thing")
                    .opt(Opt::scalar("config").short("c").long("config"))
                    .handler(|_, _ctx, _| {}),
            );

        b.iter(|| {
            let _ = app.run_with(args.clone());
        })
    });
}

criterion_group!(benches, parse_args,);

criterion_main!(benches);
