use console::style;
use std::collections::HashMap;
use std::fmt::Display;

pub fn message<T: Display>(str: T) {
    println!("{}", style(str).white().bold());
}

pub fn header<T: Display>(str: T) {
    println!(
        "{} {} {}",
        style("-=[").red().dim(),
        style(str).white().bold(),
        style("]=-").red().dim()
    );
}

pub fn note<T: Display>(str: T) {
    println!("{}", style(str).white().dim());
}

pub fn description_list(list: HashMap<String, String>) {
    let max_length = list.keys().map(|v| v.len()).max().unwrap_or(10) + 3;
    for (name, desc) in list {
        let spaced_name = format!("{:width$}", name, width = max_length);
        println!("{}{}", style(spaced_name).bold(), style(desc).dim())
    }
}

pub fn print<T: Display>(s: T) {
    println!("{}", s);
}

#[cfg(test)]
mod tests {}
