use arkham::{App, Command, Context, Opt};

fn main() {
    App::new()
        .name("Config Test Example")
        .config_filename("examples/config.toml")
        .command(
            Command::new("hello")
                .opt(Opt::scalar("name").short("n").long("name"))
                .short_desc("Prints a hello message with a passed name")
                .handler(hello),
        )
        .run()
        .unwrap();
}

fn hello(_: &App, ctx: &Context, _args: &[String]) {
    println!(
        "Hello, {}",
        ctx.get_string("name")
            .unwrap_or_else(|| "unknown".to_string())
    );
}
