use crate::{Fq, Fq3, Fq3Parameters, FQ_ONE, FQ_ZERO};
use ark_ff::{
    field_new,
    fields::fp6_2over3::{Fp6, Fp6Parameters},
};

pub type Fq6 = Fp6<Fq6Parameters>;

pub struct Fq6Parameters;

impl Fp6Parameters for Fq6Parameters {
    type Fp3Params = Fq3Parameters;

    const NONRESIDUE: Fq3 = field_new!(Fq3, FQ_ZERO, FQ_ONE, FQ_ZERO);

    const FROBENIUS_COEFF_FP6_C1: &'static [Fq] = &[
        field_new!(Fq, "1"),
        field_new!(Fq, "471738898967521029133040851318449165997304108729558973770077319830005517129946578866686957"),
        field_new!(Fq, "471738898967521029133040851318449165997304108729558973770077319830005517129946578866686956"),
        field_new!(Fq, "475922286169261325753349249653048451545124878552823515553267735739164647307408490559963136"),
        field_new!(Fq, "4183387201740296620308398334599285547820769823264541783190415909159130177461911693276180"),
        field_new!(Fq, "4183387201740296620308398334599285547820769823264541783190415909159130177461911693276181"),
    ];
}
