use crate::{Fq, Fq2, Fq2Parameters, FQ_ONE, FQ_ZERO};
use ark_ff::{
    field_new,
    fields::fp4::{Fp4, Fp4Parameters},
};

pub type Fq4 = Fp4<Fq4Parameters>;

pub struct Fq4Parameters;

impl Fp4Parameters for Fq4Parameters {
    type Fp2Params = Fq2Parameters;

    const NONRESIDUE: Fq2 = field_new!(Fq2, FQ_ZERO, FQ_ONE);

    // Coefficients for the Frobenius automorphism.
    // c1[0] = 1,
    // c1[1] = 7684163245453501615621351552473337069301082060976805004625011694147890954040864167002308
    // c1[2] = 475922286169261325753349249653048451545124879242694725395555128576210262817955800483758080
    // c1[3] = 468238122923807824137727898100575114475823797181717920390930116882062371863914936316755773
    //
    // These are calculated as `FROBENIUS_COEFF_FP4_C1[i] = Fp2Params::NONRESIDUE^((q^i - 1) / 4)`.
    #[rustfmt::skip]
    const FROBENIUS_COEFF_FP4_C1: &'static [Fq] = &[
        FQ_ONE,
        field_new!(Fq, "7684163245453501615621351552473337069301082060976805004625011694147890954040864167002308"),
        field_new!(Fq, "475922286169261325753349249653048451545124879242694725395555128576210262817955800483758080"),
        field_new!(Fq, "468238122923807824137727898100575114475823797181717920390930116882062371863914936316755773"),
    ];
}
