#![cfg_attr(not(feature = "std"), no_std)]
#![deny(
    warnings,
    unused,
    future_incompatible,
    nonstandard_style,
    rust_2018_idioms
)]
#![forbid(unsafe_code)]

//! This library implements the CP6_782 curve generated in [\[BCGMMW20, “Zexe”\]](https://eprint.iacr.org/2018/962).
//! The name denotes that it was generated using the Cocks--Pinch method for the embedding degree 6.
//! The main feature of this curve is that the scalar field equals the base field of the BLS12_377 curve.
//!
//! Curve information:
//! * Base field: q = 22369874298875696930346742206501054934775599465297184582183496627646774052458024540232479018147881220178054575403841904557897715222633333372134756426301062487682326574958588001132586331462553235407484089304633076250782629492557320825577
//! * Scalar field: r = 258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177
//! * valuation(q - 1, 2) = 3
//! * valuation(r - 1, 2) = 46
//!
//! G1 curve equation: y^2 = x^3 + ax + b, where
//! * a = 5,
//! * b = 17764315118651679038286329069295091506801468118146712649886336045535808055361274148466772191243305528312843236347777260247138934336850548243151534538734724191505953341403463040067571652261229308333392040104884438208594329793895206056414,
//!
//! G2 curve equation: y^2 = x^3 + Ax + B
//! * A = Fq3(0, 0, 5)
//! * B = Fq3(7237353553714858194254855835825640240663090882935418626687402315497764195116318527743248304684159666286416318482685337633828994152723793439622384740540789612754127688659139509552568164770448654259255628317166934203899992395064470477612, 0, 0)

mod curves;
mod fields;

pub use curves::*;
pub use fields::*;
