pub use std::sync::atomic::{AtomicUsize, Ordering};

pub static CIDX: AtomicUsize = AtomicUsize::new(0);

#[macro_export]
macro_rules! eargf {
    () => {{
        if let Some(s) = std::env::args().nth(CIDX.load(Ordering::SeqCst) + 1) {
            s
        } else {
            String::new()
        }
    }};
    ( $help:expr ) => {{
        match std::env::args().nth(CIDX.load(Ordering::SeqCst) + 1) {
            Some(s) => s,
            None => {
                $help;
                String::new()
            }
        }
    }};
}

#[macro_export]
macro_rules! argbegin {
    ( $argv0:expr, $($matcher:pat => $result:expr), *) => {
        let mut args = std::env::args().collect::<Vec<_>>();
        *$argv0 = args.remove(0);
        args.iter().for_each(|arg| {
            CIDX.fetch_add(1, Ordering::SeqCst);
            if let Some(stripped) = arg.strip_prefix('-') {
                stripped.chars().for_each(|ch| {
                    match ch {
                        $($matcher => $result),*
                    }
                });
            }
        });
    }
}
