pub mod fields_generator;
pub mod functions_generator;

use expansion::helpers::{self, DeriveInputHelper};

use syn::{AttributeArgs, spanned::Spanned};
// use syn::{parse_quote};

pub fn generate_struct(derive_input_helper: &DeriveInputHelper, args: &AttributeArgs) -> syn::Result<proc_macro2::TokenStream> {
    let fields = derive_input_helper.get_fields()?;
    let idents: Vec<_> = fields.iter().map(|f| &f.ident).collect();

    let struct_ident = &derive_input_helper.value().ident;
    let struct_name_literal = struct_ident.to_string();
    let arel_struct_name_literal = format!("{}", struct_name_literal);
    let arel_struct_ident = &syn::Ident::new(&arel_struct_name_literal, derive_input_helper.value().span());

    let builder_fields_def = fields_generator::generate_struct_fields_define(derive_input_helper)?;
    let builder_fields_init_clauses = fields_generator::generate_struct_fields_init_clauses(derive_input_helper)?;
    let builder_functions_def = functions_generator::generate_struct_functions_define(derive_input_helper)?;
    let builder_impl_arel_functions_def = functions_generator::generate_struct_impl_arel_functions_define(derive_input_helper, args)?;

    let (impl_generics, type_generics, where_clause) = derive_input_helper.value().generics.split_for_impl();

    let mut final_token_stream = proc_macro2::TokenStream::new();

    // struct UserRowRecord
    let arel_struct_row_record_name_literal = format!("{}RowRecord", struct_name_literal);
    let arel_struct_row_record_ident = &syn::Ident::new(&arel_struct_row_record_name_literal, derive_input_helper.value().span());
    {
        let init_from_db_row_init_token_streams: Vec<_> = fields.iter().map(|f| {
            let ident = &f.ident;
            let mut r#type = &f.ty;
            if let Some(inner_type) = helpers::get_type_inner_type_ident(r#type, "Option") {
                r#type = inner_type;
            }
            quote::quote! {
                #ident: if let Ok(value) = db_row.try_get::<#r#type, _>(stringify!(#ident)) { std::option::Option::Some(value) } else { std::option::Option::None },
            }
        }).collect();
        let struct_db_row_token_stream = quote::quote! {
            // UserRowRecord
            #[derive(::core::clone::Clone, ::core::fmt::Debug)]
            pub struct #arel_struct_row_record_ident #type_generics {
                #builder_fields_def
            }
            // impl UserRowRecord
            impl #impl_generics #arel_struct_row_record_ident #type_generics #where_clause {
                fn new_from_db_row(db_row: sqlx::any::AnyRow) -> anyhow::Result<Self #type_generics> {
                    Ok(Self {
                        #(#init_from_db_row_init_token_streams)*
                    })
                }
            }
        };
        final_token_stream.extend(struct_db_row_token_stream);
    }
    // struct
    {
        let struct_token_stream = quote::quote! {
            // User
            #[derive(::core::clone::Clone, ::core::fmt::Debug)]
            pub struct #arel_struct_ident #type_generics {
                persisted_row_record: std::option::Option<#arel_struct_row_record_ident #type_generics>,
                #builder_fields_def
            }
            // impl ArelAble for User
            impl #impl_generics arel::ArelAble for #arel_struct_ident #type_generics #where_clause {
                #builder_impl_arel_functions_def
                fn new_from_db_row(db_row: sqlx::any::AnyRow) -> anyhow::Result<Self #type_generics> {
                    let persisted_row_record = #arel_struct_row_record_ident::new_from_db_row(db_row)?;
                    Ok(Self {
                        #(#idents: persisted_row_record.#idents.clone(),)*
                        persisted_row_record: std::option::Option::Some(persisted_row_record),
                    })
                }
                fn assign_from_persisted_row_record(&mut self) -> anyhow::Result<&mut Self #type_generics> {
                    if let Some(persisted_row_record) = &self.persisted_row_record {
                        #(self.#idents = persisted_row_record.#idents.clone();)*
                    }
                    Ok(self)
                }
            }
            // impl User
            impl #impl_generics #arel_struct_ident #type_generics #where_clause {
                pub fn new() -> Self {
                    Self {
                        persisted_row_record: std::option::Option::None,
                        #builder_fields_init_clauses
                    }
                }
                pub fn persisted_row_record(&self) -> std::option::Option<&#arel_struct_row_record_ident #type_generics> {
                    if let Some(persisted_row_record) = &self.persisted_row_record {
                        Some(persisted_row_record)
                    } else {
                        None
                    }
                }
                #builder_functions_def
            }
        };
        final_token_stream.extend(struct_token_stream);
    }
    Ok(final_token_stream)
}