use serde_json::{Value as Json, json};
use crate::table::Table;

/// Get Model's table name.
///
/// # Examples
///
/// ```
/// use arel::traits::ModelAble;
///
/// #[derive(Clone, Debug)]
/// struct User {}
/// impl ModelAble for User {}
/// assert_eq!(User::get_table_name(), "users");
/// struct Order {}
/// impl ModelAble for Order {}
/// assert_eq!(Order::get_table_name(), "orders");
/// ```
pub trait ModelAble: Sized {
    fn get_table_name() -> String {
        Table::<Self>::get_table_name()
    }
    fn table() -> Table<Self> {
        Table::new()
    }
    fn r#where(condition: Json) -> Table<Self> {
        let mut table = Self::table();
        table.r#where(condition);
        table
    }
}
