const FORWARD_ID_BIT: u32 = 56;

fn main() {
    let forward_id_spacing = (1u64 << FORWARD_ID_BIT) - 1;
    println!("forward id space is {}", forward_id_spacing);
    let forward_id = 72057594037927934 % forward_id_spacing;
    let data_src =  (1600000000000000000) as u64;
    let data_src_prefix = data_src
        .checked_shl(FORWARD_ID_BIT)
        .expect("too many data src");

    let result = forward_id + data_src_prefix;
    println!(
        "max is {} data prfix is {} space {} forward_id {}, result is {}",
        u64::MAX,
        data_src_prefix,
        forward_id_spacing,
        forward_id,
        result
    );
}

// 18446744073709551615
// 9223372036854775808