# Contributing to our projects

Thank you for your interest in contributing to one of our projects. We want
everyone to have a positive experience contributing, so please carefully review
our only requirements for contributing:

- All contributors must agree to [our Contributor License
  Agreement](https://gist.github.com/ecton/b2e1e72abfa122da5e69ed30164f739e).
  This will be asked for during your first pull request.
- All contributors must uphold the standards of our [Code of
  Conduct](./CODE_OF_CONDUCT.md).

The rest of this document are recommendations/guidelines to help consistency and
communication within our projects.

## Creating Issues

### Reporting Bugs

To us, if something isn't behaving as you expect it to, that's a bug. Even if
it's misbehaving due to a misunderstanding, that means there's an opportunity to
improve our documentation or examples. Please don't hesitate to let us know if
you run into any issues while working with one of our projects.

### Requesting New Features

When requesting new features, please include details about what problem you're
trying to solve, not just a solution to your problem. By helping the community
understand the underlying problem, we can better evaluate what the best solution
to the problem might be.

## Contributing Changes

We openly welcome pull requests on our projects. We don't like bugs, and if
you've found one and wish to submit a fix, we greatly appreciate it.

If you find that fixing a bug requires a significant change, or you are wanting
to add a somewhat large feature, please submit a proposal as an issue first. We
want to make sure that your efforts have the highest chance of success, and a
short discussion before starting can go a long way towards a pull request being
merged with less revisions.

When working on an existing issue, update the issue to reflect that you're
working on it. This will help prevent duplicated efforts.

If you begin working on something but need some assistance, don't hesitate to
reach out inside of the issue, on [our
forums](https://community.khonsulabs.com/), or [our
Discord](https://discord.khonsulabs.com/). We will do our best to help you.

### Project-specific requirements

Be sure to check if a project's README contains additional contributing
guidelines. Each project may have different tools and commands that should be
run to validate that changes pass all requirements.
