//! Bindings for the [ARB](https://arblib.org/) library.

use libc::{c_int, c_ulong};

// Constants
pub const FMPR_RND_DOWN: c_int = 0;
pub const FMPR_RND_UP: c_int = 1;
pub const FMPR_RND_FLOOR: c_int = 2;
pub const FMPR_RND_CEIL: c_int = 3;
pub const FMPR_RND_NEAR: c_int = 4;
pub const MAG_BITS: c_int = 30;
pub const ARF_RND_DOWN: c_int = 0;
pub const ARF_RND_UP: c_int = 1;
pub const ARF_RND_FLOOR: c_int = 2;
pub const ARF_RND_CEIL: c_int = 3;
pub const ARF_RND_NEAR: c_int = 4;
pub const ARF_RESULT_EXACT: c_int = 0;
pub const ARF_RESULT_INEXACT: c_int = 1;
pub const ARF_EXP_ZERO: c_int = 0;
pub const ARF_NOPTR_LIMBS: c_int = 2;
pub const MUL_MPFR_MIN_LIMBS: c_int = 25;
pub const MUL_MPFR_MAX_LIMBS: c_int = 10000;
pub const ARF_MUL_STACK_ALLOC: c_int = 40;
pub const ARF_MUL_TLS_ALLOC: c_int = 1000;
pub const ARF_ADD_STACK_ALLOC: c_int = 40;
pub const ARF_ADD_TLS_ALLOC: c_int = 1000;
pub const __ARB_VERSION: c_int = 2;
pub const __ARB_VERSION_MINOR: c_int = 20;
pub const __ARB_VERSION_PATCHLEVEL: c_int = 0;
pub const ARB_VERSION: &'static [u8; 7usize] = b"2.20.0\0";
pub const __ARB_RELEASE: c_int = 22000;
pub const ARB_STR_MORE: c_ulong = 1;
pub const ARB_STR_NO_RADIUS: c_ulong = 2;
pub const ARB_STR_CONDENSE: c_ulong = 16;
pub const ARB_RND: c_int = 0;
pub const ARB_ATAN_TAB1_BITS: c_int = 8;
pub const ARB_ATAN_TAB1_PREC: c_int = 512;
pub const ARB_ATAN_TAB1_LIMBS: c_int = 8;
pub const ARB_ATAN_TAB21_BITS: c_int = 5;
pub const ARB_ATAN_TAB22_BITS: c_int = 5;
pub const ARB_ATAN_TAB2_PREC: c_int = 4608;
pub const ARB_ATAN_TAB2_LIMBS: c_int = 72;
pub const ARB_LOG_TAB11_BITS: c_int = 7;
pub const ARB_LOG_TAB12_BITS: c_int = 7;
pub const ARB_LOG_TAB1_PREC: c_int = 512;
pub const ARB_LOG_TAB1_LIMBS: c_int = 8;
pub const ARB_LOG_TAB21_BITS: c_int = 5;
pub const ARB_LOG_TAB22_BITS: c_int = 5;
pub const ARB_LOG_TAB2_PREC: c_int = 4608;
pub const ARB_LOG_TAB2_LIMBS: c_int = 72;
pub const ARB_EXP_TAB1_NUM: c_int = 178;
pub const ARB_EXP_TAB1_BITS: c_int = 8;
pub const ARB_EXP_TAB1_PREC: c_int = 512;
pub const ARB_EXP_TAB1_LIMBS: c_int = 8;
pub const ARB_EXP_TAB21_NUM: c_int = 23;
pub const ARB_EXP_TAB21_BITS: c_int = 5;
pub const ARB_EXP_TAB22_BITS: c_int = 5;
pub const ARB_EXP_TAB2_PREC: c_int = 4608;
pub const ARB_EXP_TAB2_LIMBS: c_int = 72;
pub const ARB_SIN_COS_TAB1_NUM: c_int = 203;
pub const ARB_SIN_COS_TAB1_BITS: c_int = 8;
pub const ARB_SIN_COS_TAB1_PREC: c_int = 512;
pub const ARB_SIN_COS_TAB1_LIMBS: c_int = 8;
pub const ARB_SIN_COS_TAB21_NUM: c_int = 26;
pub const ARB_SIN_COS_TAB21_BITS: c_int = 5;
pub const ARB_SIN_COS_TAB22_BITS: c_int = 5;
pub const ARB_SIN_COS_TAB2_PREC: c_int = 4608;
pub const ARB_SIN_COS_TAB2_LIMBS: c_int = 72;
pub const ARB_PI4_TAB_LIMBS: c_int = 72;
pub const ACB_LAMBERTW_LEFT: c_int = 2;
pub const ACB_LAMBERTW_MIDDLE: c_int = 4;
pub const FLINT_DEFAULT_THREAD_LIMIT: c_int = 99999;
pub const NMOD_MAT_MUL_TRANSPOSE_CUTOFF: c_int = 20;
pub const NMOD_MAT_SOLVE_TRI_ROWS_CUTOFF: c_int = 64;
pub const NMOD_MAT_SOLVE_TRI_COLS_CUTOFF: c_int = 64;
pub const NMOD_MAT_LU_RECURSIVE_CUTOFF: c_int = 4;
pub const NMOD_MAT_OPTIMAL_MODULUS_BITS: c_int = 59;
pub const NMOD_DIVREM_DIVCONQUER_CUTOFF: c_int = 300;
pub const NMOD_DIV_DIVCONQUER_CUTOFF: c_int = 300;
pub const NMOD_POLY_HGCD_CUTOFF: c_int = 100;
pub const NMOD_POLY_GCD_CUTOFF: c_int = 340;
pub const NMOD_POLY_SMALL_GCD_CUTOFF: c_int = 200;
pub const FMPZ_POLY_INV_NEWTON_CUTOFF: c_int = 32;
pub const FMPZ_POLY_SQRT_DIVCONQUER_CUTOFF: c_int = 16;
pub const FMPZ_POLY_SQRTREM_DIVCONQUER_CUTOFF: c_int = 16;
pub const D_BITS: c_int = 53;
pub const WEAK_CANONICALISE_CUTOFF: c_int = 25600;
pub const ARB_CALC_SUCCESS: c_int = 0;
pub const ARB_CALC_IMPRECISE_INPUT: c_int = 1;
pub const ARB_CALC_NO_CONVERGENCE: c_int = 2;
pub const DLOG_SMALL_LIM: c_int = 50;
pub const DLOG_TABLE_LIM: c_int = 50;
pub const DLOG_TABLE_P_LIM: c_int = 50;
pub const DLOG_TABLE_MODPE_LIM: c_int = 50;
pub const DLOG_TABLE_PE_LIM: c_int = 50;
pub const DLOG_TABLE_N_LIM: c_int = 50;
pub const DLOG_BSGS_LIM: c_int = 500;
pub const DLOG_LOOP_MAX_FACTOR: c_int = 6;
pub const DLOG_G_SMALL: c_int = 0;
pub const DLOG_G_BIG: c_int = 1;
pub const CRT_MAX: c_int = 15;
pub const DFT_VERB: c_int = 0;
pub const MAX_FACTORS: c_int = 15;
pub const ACB_HYPGEOM_2F1_REGULARIZED: c_int = 1;
pub const ACB_HYPGEOM_2F1_AB: c_int = 2;
pub const ACB_HYPGEOM_2F1_AC: c_int = 4;
pub const ACB_HYPGEOM_2F1_BC: c_int = 8;
pub const ACB_HYPGEOM_2F1_ABC: c_int = 16;
pub const ARB_FMPZ_POLY_ROOTS_VERBOSE: c_int = 1;
pub const BELL_NUMBER_TAB_SIZE: c_int = 26;
pub const SMALL_EULER_LIMIT: c_int = 25;
pub const BERNOULLI_SMALL_NUMER_LIMIT: c_int = 35;
pub const BERNOULLI_REV_MIN: c_int = 32;

pub mod acb;
pub mod acb_calc;
pub mod acb_dft;
pub mod acb_dirichlet;
pub mod acb_elliptic;
pub mod acb_hypgeom;
pub mod acb_mat;
pub mod acb_modular;
pub mod acb_poly;
pub mod arb;
pub mod arb_calc;
pub mod arb_fmpz_poly;
pub mod arb_hypgeom;
pub mod arb_mat;
pub mod arb_poly;
pub mod arf;
pub mod arith;
pub mod bernoulli;
pub mod bool_mat;
pub mod dirichlet;
pub mod dlog;
pub mod fmpr;
pub mod hypgeom;
pub mod mag;
pub mod partition;
