//! This crate contains (mostly) safe bindings to the [Aravis][aravis] library.
//! The bindings are mostly auto-generated with the [`gir`][gir-tool] tool from the [gtk-rs][gtk-rs] project.
//!
//! This crate currently targets version 0.8.14 of the Aravis library.
//!
//! The autogenerated API uses extension traits to implement methods for many structs.
//! This is done by the `gir` tool to emulate class inheritance.
//! Practically, this means that you should also look the [`CameraExt`] trait if you want to know what you can do with a [`Camera`].
//!
//! You can import the prelude to bring all available extension traits in scope:
//! ```rust
//! use aravis::prelude::*;
//! ```
//!
//! # Migrating from 0.6
//! The API was regenerated with a new version of the `gir` tool.
//! As a result, the public API has changed a bit:
//! * Getters no-longer have a `get_` prefix, so a function that was called `get_foo()` is now simply called `foo()`.
//! * Methods for classes without subclasses no-longer live in `*Ext` traits.
//!   For example, this means that all methods for [`Buffer`] objects are now directly implemented on the `Buffer` struct.
//!   This mostly means you can just remove the import of traits that no longer exist.
//!
//! # Documentation copyright
//! This documentation constist mainly of original documentation of the Aravis project.
//! The copyright and license of the Aravis project apply to those parts.
//! The [full original documentation][aravis-docs] is also available online and might help if the translation to Rust made things unclear.
//!
//! [aravis]: https://github.com/AravisProject/aravis
//! [aravis-docs]: https://aravisproject.github.io/docs/aravis-0.8/
//! [gir-tool]: https://github.com/gtk-rs/gir
//! [gtk-rs]: https://gtk-rs.org/

#![cfg_attr(feature = "nightly", feature(new_uninit))]
#![cfg_attr(feature = "nightly", feature(maybe_uninit_slice))]
#![cfg_attr(feature = "nightly", feature(doc_cfg))]

extern crate aravis_sys as ffi;
extern crate gio;
extern crate gio_sys;
pub extern crate glib;
extern crate glib_sys;
extern crate gobject_sys;
extern crate image;

macro_rules! assert_initialized_main_thread {
	() => {};
}

/// No-op.
macro_rules! skip_assert_initialized {
	() => {};
}

#[allow(clippy::all)]
mod auto;
pub use auto::*;

mod manual;
pub use manual::*;

pub use auto::traits::*;
pub use manual::traits::*;

pub mod prelude {
	pub use auto::traits::*;
	pub use manual::traits::*;
}
