// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::FakeCamera;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
	#[doc(alias = "ArvGvFakeCamera")]
	pub struct GvFakeCamera(Object<ffi::ArvGvFakeCamera, ffi::ArvGvFakeCameraClass>);

	match fn {
		type_ => || ffi::arv_gv_fake_camera_get_type(),
	}
}

impl GvFakeCamera {
	/// ## `interface_name`
	/// listening network interface ('lo' by default)
	/// ## `serial_number`
	/// fake device serial number ('GV01' by default)
	///
	/// # Returns
	///
	/// a new [`GvFakeCamera`][crate::GvFakeCamera]
	#[doc(alias = "arv_gv_fake_camera_new")]
	pub fn new(interface_name: Option<&str>, serial_number: Option<&str>) -> GvFakeCamera {
		assert_initialized_main_thread!();
		unsafe {
			from_glib_full(ffi::arv_gv_fake_camera_new(
				interface_name.to_glib_none().0,
				serial_number.to_glib_none().0,
			))
		}
	}

	/// ## `interface_name`
	/// listening network interface, default is lo
	/// ## `serial_number`
	/// fake device serial number, default is GV01
	/// ## `genicam_filename`
	/// path to alternative genicam data
	///
	/// # Returns
	///
	/// a new [`GvFakeCamera`][crate::GvFakeCamera]
	#[doc(alias = "arv_gv_fake_camera_new_full")]
	pub fn new_full(
		interface_name: Option<&str>,
		serial_number: Option<&str>,
		genicam_filename: Option<&str>,
	) -> GvFakeCamera {
		assert_initialized_main_thread!();
		unsafe {
			from_glib_full(ffi::arv_gv_fake_camera_new_full(
				interface_name.to_glib_none().0,
				serial_number.to_glib_none().0,
				genicam_filename.to_glib_none().0,
			))
		}
	}

	/// Retrieves the underlying [`FakeCamera`][crate::FakeCamera] object owned by `self`.
	///
	/// # Returns
	///
	/// underlying fake camera object.
	#[doc(alias = "arv_gv_fake_camera_get_fake_camera")]
	#[doc(alias = "get_fake_camera")]
	pub fn fake_camera(&self) -> Option<FakeCamera> {
		unsafe {
			from_glib_none(ffi::arv_gv_fake_camera_get_fake_camera(
				self.to_glib_none().0,
			))
		}
	}

	///
	/// # Returns
	///
	/// [`true`] if the fake camera is correctly listening on the GVCP port
	#[doc(alias = "arv_gv_fake_camera_is_running")]
	pub fn is_running(&self) -> bool {
		unsafe { from_glib(ffi::arv_gv_fake_camera_is_running(self.to_glib_none().0)) }
	}

	#[doc(alias = "gvsp-lost-ratio")]
	pub fn set_gvsp_lost_ratio(&self, gvsp_lost_ratio: f64) {
		unsafe {
			glib::gobject_ffi::g_object_set_property(
				self.as_ptr() as *mut glib::gobject_ffi::GObject,
				b"gvsp-lost-ratio\0".as_ptr() as *const _,
				gvsp_lost_ratio.to_value().to_glib_none().0,
			);
		}
	}

	#[doc(alias = "gvsp-lost-ratio")]
	pub fn connect_gvsp_lost_ratio_notify<F: Fn(&Self) + Send + 'static>(
		&self,
		f: F,
	) -> SignalHandlerId {
		unsafe extern "C" fn notify_gvsp_lost_ratio_trampoline<
			F: Fn(&GvFakeCamera) + Send + 'static,
		>(
			this: *mut ffi::ArvGvFakeCamera,
			_param_spec: glib::ffi::gpointer,
			f: glib::ffi::gpointer,
		) {
			let f: &F = &*(f as *const F);
			f(&from_glib_borrow(this))
		}
		unsafe {
			let f: Box_<F> = Box_::new(f);
			connect_raw(
				self.as_ptr() as *mut _,
				b"notify::gvsp-lost-ratio\0".as_ptr() as *const _,
				Some(transmute::<_, unsafe extern "C" fn()>(
					notify_gvsp_lost_ratio_trampoline::<F> as *const (),
				)),
				Box_::into_raw(f),
			)
		}
	}
}

unsafe impl Send for GvFakeCamera {}

impl fmt::Display for GvFakeCamera {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("GvFakeCamera")
	}
}
