// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::Device;
use crate::GvPacketSizeAdjustment;
use crate::GvStreamOption;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
	#[doc(alias = "ArvGvDevice")]
	pub struct GvDevice(Object<ffi::ArvGvDevice, ffi::ArvGvDeviceClass>) @extends Device;

	match fn {
		type_ => || ffi::arv_gv_device_get_type(),
	}
}

impl GvDevice {
	/// ## `interface_address`
	/// address of the interface connected to the device
	/// ## `device_address`
	/// device address
	///
	/// # Returns
	///
	/// a newly created [`Device`][crate::Device] using GigE protocol
	#[doc(alias = "arv_gv_device_new")]
	pub fn new<P: IsA<gio::InetAddress>, Q: IsA<gio::InetAddress>>(
		interface_address: &P,
		device_address: &Q,
	) -> Result<GvDevice, glib::Error> {
		assert_initialized_main_thread!();
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gv_device_new(
				interface_address.as_ref().to_glib_none().0,
				device_address.as_ref().to_glib_none().0,
				&mut error,
			);
			if error.is_null() {
				Ok(Device::from_glib_full(ret).unsafe_cast())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	/// Automatically determine the biggest packet size that can be used data streaming, and set GevSCPSPacketSize value
	/// accordingly. This function relies on the GevSCPSFireTestPacket feature.
	///
	/// # Returns
	///
	/// The automatic packet size, in bytes, or the current one if GevSCPSFireTestPacket is not supported.
	#[doc(alias = "arv_gv_device_auto_packet_size")]
	pub fn auto_packet_size(&self) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ = ffi::arv_gv_device_auto_packet_size(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	///
	/// # Returns
	///
	/// the device IP address.
	#[doc(alias = "arv_gv_device_get_device_address")]
	#[doc(alias = "get_device_address")]
	pub fn device_address(&self) -> Option<gio::SocketAddress> {
		unsafe { from_glib_none(ffi::arv_gv_device_get_device_address(self.to_glib_none().0)) }
	}

	///
	/// # Returns
	///
	/// the device host interface IP address.
	#[doc(alias = "arv_gv_device_get_interface_address")]
	#[doc(alias = "get_interface_address")]
	pub fn interface_address(&self) -> Option<gio::SocketAddress> {
		unsafe {
			from_glib_none(ffi::arv_gv_device_get_interface_address(
				self.to_glib_none().0,
			))
		}
	}

	#[doc(alias = "arv_gv_device_get_packet_size")]
	#[doc(alias = "get_packet_size")]
	pub fn packet_size(&self) -> Result<u32, glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gv_device_get_packet_size(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(ret)
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	///
	/// # Returns
	///
	/// options for stream creation
	#[doc(alias = "arv_gv_device_get_stream_options")]
	#[doc(alias = "get_stream_options")]
	pub fn stream_options(&self) -> GvStreamOption {
		unsafe { from_glib(ffi::arv_gv_device_get_stream_options(self.to_glib_none().0)) }
	}

	#[doc(alias = "arv_gv_device_get_timestamp_tick_frequency")]
	#[doc(alias = "get_timestamp_tick_frequency")]
	pub fn timestamp_tick_frequency(&self) -> Result<u64, glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let ret =
				ffi::arv_gv_device_get_timestamp_tick_frequency(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(ret)
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	///
	/// # Returns
	///
	/// value indicating whether the ArvGvDevice has control access to the camera
	#[doc(alias = "arv_gv_device_is_controller")]
	pub fn is_controller(&self) -> bool {
		unsafe { from_glib(ffi::arv_gv_device_is_controller(self.to_glib_none().0)) }
	}

	///
	/// # Returns
	///
	/// whether the control was successfully relinquished
	#[cfg(any(feature = "v0_8_3", feature = "dox"))]
	#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8_3")))]
	#[doc(alias = "arv_gv_device_leave_control")]
	pub fn leave_control(&self) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ = ffi::arv_gv_device_leave_control(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	#[doc(alias = "arv_gv_device_set_packet_size")]
	pub fn set_packet_size(&self, packet_size: i32) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ =
				ffi::arv_gv_device_set_packet_size(self.to_glib_none().0, packet_size, &mut error);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	/// Sets the option for the packet size adjustment happening at stream object creation. See
	/// [`auto_packet_size()`][Self::auto_packet_size()] for a description of the packet adjustment feature. The default behaviour is
	/// `ARV_GV_PACKET_SIZE_ADJUSTEMENT_ON_FAILURE_ONCE`, which means the packet size is adjusted if the current packet size
	/// check fails, and only the first time `arv_device_create_stream()` is successfully called during `self` instance
	/// life.
	/// ## `adjustment`
	/// a [`GvPacketSizeAdjustment`][crate::GvPacketSizeAdjustment] option
	#[cfg(any(feature = "v0_8_3", feature = "dox"))]
	#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8_3")))]
	#[doc(alias = "arv_gv_device_set_packet_size_adjustment")]
	pub fn set_packet_size_adjustment(&self, adjustment: GvPacketSizeAdjustment) {
		unsafe {
			ffi::arv_gv_device_set_packet_size_adjustment(
				self.to_glib_none().0,
				adjustment.into_glib(),
			);
		}
	}

	/// Sets the option used during stream creation. It must be called before `arv_device_create_stream()`.
	/// ## `options`
	/// options for stream creation
	#[doc(alias = "arv_gv_device_set_stream_options")]
	pub fn set_stream_options(&self, options: GvStreamOption) {
		unsafe {
			ffi::arv_gv_device_set_stream_options(self.to_glib_none().0, options.into_glib());
		}
	}

	///
	/// # Returns
	///
	/// whether the control was successfully acquired
	#[cfg(any(feature = "v0_8_3", feature = "dox"))]
	#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8_3")))]
	#[doc(alias = "arv_gv_device_take_control")]
	pub fn take_control(&self) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ = ffi::arv_gv_device_take_control(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	#[doc(alias = "packet-size-adjustment")]
	pub fn packet_size_adjustment(&self) -> GvPacketSizeAdjustment {
		unsafe {
			let mut value =
				glib::Value::from_type(<GvPacketSizeAdjustment as StaticType>::static_type());
			glib::gobject_ffi::g_object_get_property(
				self.as_ptr() as *mut glib::gobject_ffi::GObject,
				b"packet-size-adjustment\0".as_ptr() as *const _,
				value.to_glib_none_mut().0,
			);
			value
				.get()
				.expect("Return Value for property `packet-size-adjustment` getter")
		}
	}

	#[doc(alias = "packet-size-adjustment")]
	pub fn set_property_packet_size_adjustment(
		&self,
		packet_size_adjustment: GvPacketSizeAdjustment,
	) {
		unsafe {
			glib::gobject_ffi::g_object_set_property(
				self.as_ptr() as *mut glib::gobject_ffi::GObject,
				b"packet-size-adjustment\0".as_ptr() as *const _,
				packet_size_adjustment.to_value().to_glib_none().0,
			);
		}
	}

	#[doc(alias = "packet-size-adjustment")]
	pub fn connect_packet_size_adjustment_notify<F: Fn(&Self) + Send + 'static>(
		&self,
		f: F,
	) -> SignalHandlerId {
		unsafe extern "C" fn notify_packet_size_adjustment_trampoline<
			F: Fn(&GvDevice) + Send + 'static,
		>(
			this: *mut ffi::ArvGvDevice,
			_param_spec: glib::ffi::gpointer,
			f: glib::ffi::gpointer,
		) {
			let f: &F = &*(f as *const F);
			f(&from_glib_borrow(this))
		}
		unsafe {
			let f: Box_<F> = Box_::new(f);
			connect_raw(
				self.as_ptr() as *mut _,
				b"notify::packet-size-adjustment\0".as_ptr() as *const _,
				Some(transmute::<_, unsafe extern "C" fn()>(
					notify_packet_size_adjustment_trampoline::<F> as *const (),
				)),
				Box_::into_raw(f),
			)
		}
	}
}

unsafe impl Send for GvDevice {}

impl fmt::Display for GvDevice {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("GvDevice")
	}
}
