// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvAcquisitionMode")]
pub enum AcquisitionMode {
	#[doc(alias = "ARV_ACQUISITION_MODE_CONTINUOUS")]
	Continuous,
	#[doc(alias = "ARV_ACQUISITION_MODE_SINGLE_FRAME")]
	SingleFrame,
	#[doc(alias = "ARV_ACQUISITION_MODE_MULTI_FRAME")]
	MultiFrame,
	#[doc(hidden)]
	__Unknown(i32),
}

impl AcquisitionMode {
	#[doc(alias = "arv_acquisition_mode_from_string")]
	pub fn from_string(string: &str) -> AcquisitionMode {
		assert_initialized_main_thread!();
		unsafe {
			from_glib(ffi::arv_acquisition_mode_from_string(
				string.to_glib_none().0,
			))
		}
	}

	#[doc(alias = "arv_acquisition_mode_to_string")]
	#[doc(alias = "to_string")]
	pub fn to_str(self) -> Option<glib::GString> {
		assert_initialized_main_thread!();
		unsafe { from_glib_none(ffi::arv_acquisition_mode_to_string(self.into_glib())) }
	}
}

impl fmt::Display for AcquisitionMode {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"AcquisitionMode::{}",
			match *self {
				Self::Continuous => "Continuous",
				Self::SingleFrame => "SingleFrame",
				Self::MultiFrame => "MultiFrame",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for AcquisitionMode {
	type GlibType = ffi::ArvAcquisitionMode;

	fn into_glib(self) -> ffi::ArvAcquisitionMode {
		match self {
			Self::Continuous => ffi::ARV_ACQUISITION_MODE_CONTINUOUS,
			Self::SingleFrame => ffi::ARV_ACQUISITION_MODE_SINGLE_FRAME,
			Self::MultiFrame => ffi::ARV_ACQUISITION_MODE_MULTI_FRAME,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvAcquisitionMode> for AcquisitionMode {
	unsafe fn from_glib(value: ffi::ArvAcquisitionMode) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_ACQUISITION_MODE_CONTINUOUS => Self::Continuous,
			ffi::ARV_ACQUISITION_MODE_SINGLE_FRAME => Self::SingleFrame,
			ffi::ARV_ACQUISITION_MODE_MULTI_FRAME => Self::MultiFrame,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for AcquisitionMode {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_acquisition_mode_get_type()) }
	}
}

impl glib::value::ValueType for AcquisitionMode {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AcquisitionMode {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for AcquisitionMode {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvAuto")]
pub enum Auto {
	#[doc(alias = "ARV_AUTO_OFF")]
	Off,
	#[doc(alias = "ARV_AUTO_ONCE")]
	Once,
	#[doc(alias = "ARV_AUTO_CONTINUOUS")]
	Continuous,
	#[doc(hidden)]
	__Unknown(i32),
}

impl Auto {
	#[doc(alias = "arv_auto_from_string")]
	pub fn from_string(string: &str) -> Auto {
		assert_initialized_main_thread!();
		unsafe { from_glib(ffi::arv_auto_from_string(string.to_glib_none().0)) }
	}

	#[doc(alias = "arv_auto_to_string")]
	#[doc(alias = "to_string")]
	pub fn to_str(self) -> Option<glib::GString> {
		assert_initialized_main_thread!();
		unsafe { from_glib_none(ffi::arv_auto_to_string(self.into_glib())) }
	}
}

impl fmt::Display for Auto {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"Auto::{}",
			match *self {
				Self::Off => "Off",
				Self::Once => "Once",
				Self::Continuous => "Continuous",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for Auto {
	type GlibType = ffi::ArvAuto;

	fn into_glib(self) -> ffi::ArvAuto {
		match self {
			Self::Off => ffi::ARV_AUTO_OFF,
			Self::Once => ffi::ARV_AUTO_ONCE,
			Self::Continuous => ffi::ARV_AUTO_CONTINUOUS,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvAuto> for Auto {
	unsafe fn from_glib(value: ffi::ArvAuto) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_AUTO_OFF => Self::Off,
			ffi::ARV_AUTO_ONCE => Self::Once,
			ffi::ARV_AUTO_CONTINUOUS => Self::Continuous,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for Auto {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_auto_get_type()) }
	}
}

impl glib::value::ValueType for Auto {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Auto {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for Auto {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvBufferPayloadType")]
pub enum BufferPayloadType {
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_UNKNOWN")]
	Unknown,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_IMAGE")]
	Image,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_RAWDATA")]
	Rawdata,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_FILE")]
	File,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_CHUNK_DATA")]
	ChunkData,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_EXTENDED_CHUNK_DATA")]
	ExtendedChunkData,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_JPEG")]
	Jpeg,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_JPEG2000")]
	Jpeg2000,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_H264")]
	H264,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_MULTIZONE_IMAGE")]
	MultizoneImage,
	#[doc(alias = "ARV_BUFFER_PAYLOAD_TYPE_IMAGE_EXTENDED_CHUNK")]
	ImageExtendedChunk,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for BufferPayloadType {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"BufferPayloadType::{}",
			match *self {
				Self::Unknown => "Unknown",
				Self::Image => "Image",
				Self::Rawdata => "Rawdata",
				Self::File => "File",
				Self::ChunkData => "ChunkData",
				Self::ExtendedChunkData => "ExtendedChunkData",
				Self::Jpeg => "Jpeg",
				Self::Jpeg2000 => "Jpeg2000",
				Self::H264 => "H264",
				Self::MultizoneImage => "MultizoneImage",
				Self::ImageExtendedChunk => "ImageExtendedChunk",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for BufferPayloadType {
	type GlibType = ffi::ArvBufferPayloadType;

	fn into_glib(self) -> ffi::ArvBufferPayloadType {
		match self {
			Self::Unknown => ffi::ARV_BUFFER_PAYLOAD_TYPE_UNKNOWN,
			Self::Image => ffi::ARV_BUFFER_PAYLOAD_TYPE_IMAGE,
			Self::Rawdata => ffi::ARV_BUFFER_PAYLOAD_TYPE_RAWDATA,
			Self::File => ffi::ARV_BUFFER_PAYLOAD_TYPE_FILE,
			Self::ChunkData => ffi::ARV_BUFFER_PAYLOAD_TYPE_CHUNK_DATA,
			Self::ExtendedChunkData => ffi::ARV_BUFFER_PAYLOAD_TYPE_EXTENDED_CHUNK_DATA,
			Self::Jpeg => ffi::ARV_BUFFER_PAYLOAD_TYPE_JPEG,
			Self::Jpeg2000 => ffi::ARV_BUFFER_PAYLOAD_TYPE_JPEG2000,
			Self::H264 => ffi::ARV_BUFFER_PAYLOAD_TYPE_H264,
			Self::MultizoneImage => ffi::ARV_BUFFER_PAYLOAD_TYPE_MULTIZONE_IMAGE,
			Self::ImageExtendedChunk => ffi::ARV_BUFFER_PAYLOAD_TYPE_IMAGE_EXTENDED_CHUNK,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvBufferPayloadType> for BufferPayloadType {
	unsafe fn from_glib(value: ffi::ArvBufferPayloadType) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_BUFFER_PAYLOAD_TYPE_UNKNOWN => Self::Unknown,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_IMAGE => Self::Image,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_RAWDATA => Self::Rawdata,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_FILE => Self::File,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_CHUNK_DATA => Self::ChunkData,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_EXTENDED_CHUNK_DATA => Self::ExtendedChunkData,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_JPEG => Self::Jpeg,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_JPEG2000 => Self::Jpeg2000,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_H264 => Self::H264,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_MULTIZONE_IMAGE => Self::MultizoneImage,
			ffi::ARV_BUFFER_PAYLOAD_TYPE_IMAGE_EXTENDED_CHUNK => Self::ImageExtendedChunk,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for BufferPayloadType {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_buffer_payload_type_get_type()) }
	}
}

impl glib::value::ValueType for BufferPayloadType {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BufferPayloadType {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for BufferPayloadType {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvBufferStatus")]
pub enum BufferStatus {
	#[doc(alias = "ARV_BUFFER_STATUS_UNKNOWN")]
	Unknown,
	#[doc(alias = "ARV_BUFFER_STATUS_SUCCESS")]
	Success,
	#[doc(alias = "ARV_BUFFER_STATUS_CLEARED")]
	Cleared,
	#[doc(alias = "ARV_BUFFER_STATUS_TIMEOUT")]
	Timeout,
	#[doc(alias = "ARV_BUFFER_STATUS_MISSING_PACKETS")]
	MissingPackets,
	#[doc(alias = "ARV_BUFFER_STATUS_WRONG_PACKET_ID")]
	WrongPacketId,
	#[doc(alias = "ARV_BUFFER_STATUS_SIZE_MISMATCH")]
	SizeMismatch,
	#[doc(alias = "ARV_BUFFER_STATUS_FILLING")]
	Filling,
	#[doc(alias = "ARV_BUFFER_STATUS_ABORTED")]
	Aborted,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for BufferStatus {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"BufferStatus::{}",
			match *self {
				Self::Unknown => "Unknown",
				Self::Success => "Success",
				Self::Cleared => "Cleared",
				Self::Timeout => "Timeout",
				Self::MissingPackets => "MissingPackets",
				Self::WrongPacketId => "WrongPacketId",
				Self::SizeMismatch => "SizeMismatch",
				Self::Filling => "Filling",
				Self::Aborted => "Aborted",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for BufferStatus {
	type GlibType = ffi::ArvBufferStatus;

	fn into_glib(self) -> ffi::ArvBufferStatus {
		match self {
			Self::Unknown => ffi::ARV_BUFFER_STATUS_UNKNOWN,
			Self::Success => ffi::ARV_BUFFER_STATUS_SUCCESS,
			Self::Cleared => ffi::ARV_BUFFER_STATUS_CLEARED,
			Self::Timeout => ffi::ARV_BUFFER_STATUS_TIMEOUT,
			Self::MissingPackets => ffi::ARV_BUFFER_STATUS_MISSING_PACKETS,
			Self::WrongPacketId => ffi::ARV_BUFFER_STATUS_WRONG_PACKET_ID,
			Self::SizeMismatch => ffi::ARV_BUFFER_STATUS_SIZE_MISMATCH,
			Self::Filling => ffi::ARV_BUFFER_STATUS_FILLING,
			Self::Aborted => ffi::ARV_BUFFER_STATUS_ABORTED,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvBufferStatus> for BufferStatus {
	unsafe fn from_glib(value: ffi::ArvBufferStatus) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_BUFFER_STATUS_UNKNOWN => Self::Unknown,
			ffi::ARV_BUFFER_STATUS_SUCCESS => Self::Success,
			ffi::ARV_BUFFER_STATUS_CLEARED => Self::Cleared,
			ffi::ARV_BUFFER_STATUS_TIMEOUT => Self::Timeout,
			ffi::ARV_BUFFER_STATUS_MISSING_PACKETS => Self::MissingPackets,
			ffi::ARV_BUFFER_STATUS_WRONG_PACKET_ID => Self::WrongPacketId,
			ffi::ARV_BUFFER_STATUS_SIZE_MISMATCH => Self::SizeMismatch,
			ffi::ARV_BUFFER_STATUS_FILLING => Self::Filling,
			ffi::ARV_BUFFER_STATUS_ABORTED => Self::Aborted,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for BufferStatus {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_buffer_status_get_type()) }
	}
}

impl glib::value::ValueType for BufferStatus {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BufferStatus {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for BufferStatus {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvChunkParserError")]
pub enum ChunkParserError {
	#[doc(alias = "ARV_CHUNK_PARSER_ERROR_INVALID_FEATURE_TYPE")]
	InvalidFeatureType,
	#[doc(alias = "ARV_CHUNK_PARSER_ERROR_BUFFER_NOT_FOUND")]
	BufferNotFound,
	#[doc(alias = "ARV_CHUNK_PARSER_ERROR_CHUNK_NOT_FOUND")]
	ChunkNotFound,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for ChunkParserError {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"ChunkParserError::{}",
			match *self {
				Self::InvalidFeatureType => "InvalidFeatureType",
				Self::BufferNotFound => "BufferNotFound",
				Self::ChunkNotFound => "ChunkNotFound",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for ChunkParserError {
	type GlibType = ffi::ArvChunkParserError;

	fn into_glib(self) -> ffi::ArvChunkParserError {
		match self {
			Self::InvalidFeatureType => ffi::ARV_CHUNK_PARSER_ERROR_INVALID_FEATURE_TYPE,
			Self::BufferNotFound => ffi::ARV_CHUNK_PARSER_ERROR_BUFFER_NOT_FOUND,
			Self::ChunkNotFound => ffi::ARV_CHUNK_PARSER_ERROR_CHUNK_NOT_FOUND,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvChunkParserError> for ChunkParserError {
	unsafe fn from_glib(value: ffi::ArvChunkParserError) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_CHUNK_PARSER_ERROR_INVALID_FEATURE_TYPE => Self::InvalidFeatureType,
			ffi::ARV_CHUNK_PARSER_ERROR_BUFFER_NOT_FOUND => Self::BufferNotFound,
			ffi::ARV_CHUNK_PARSER_ERROR_CHUNK_NOT_FOUND => Self::ChunkNotFound,
			value => Self::__Unknown(value),
		}
	}
}

impl ErrorDomain for ChunkParserError {
	fn domain() -> Quark {
		skip_assert_initialized!();

		unsafe { from_glib(ffi::arv_chunk_parser_error_quark()) }
	}

	fn code(self) -> i32 {
		self.into_glib()
	}

	fn from(code: i32) -> Option<Self> {
		skip_assert_initialized!();
		match code {
			ffi::ARV_CHUNK_PARSER_ERROR_INVALID_FEATURE_TYPE => Some(Self::InvalidFeatureType),
			ffi::ARV_CHUNK_PARSER_ERROR_BUFFER_NOT_FOUND => Some(Self::BufferNotFound),
			ffi::ARV_CHUNK_PARSER_ERROR_CHUNK_NOT_FOUND => Some(Self::ChunkNotFound),
			value => Some(Self::__Unknown(value)),
		}
	}
}

impl StaticType for ChunkParserError {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_chunk_parser_error_get_type()) }
	}
}

impl glib::value::ValueType for ChunkParserError {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ChunkParserError {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for ChunkParserError {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvDeviceError")]
pub enum DeviceError {
	#[doc(alias = "ARV_DEVICE_ERROR_WRONG_FEATURE")]
	WrongFeature,
	#[doc(alias = "ARV_DEVICE_ERROR_FEATURE_NOT_FOUND")]
	FeatureNotFound,
	#[doc(alias = "ARV_DEVICE_ERROR_NOT_CONNECTED")]
	NotConnected,
	#[doc(alias = "ARV_DEVICE_ERROR_PROTOCOL_ERROR")]
	ProtocolError,
	#[doc(alias = "ARV_DEVICE_ERROR_TRANSFER_ERROR")]
	TransferError,
	#[doc(alias = "ARV_DEVICE_ERROR_TIMEOUT")]
	Timeout,
	#[doc(alias = "ARV_DEVICE_ERROR_NOT_FOUND")]
	NotFound,
	#[doc(alias = "ARV_DEVICE_ERROR_INVALID_PARAMETER")]
	InvalidParameter,
	#[doc(alias = "ARV_DEVICE_ERROR_GENICAM_NOT_FOUND")]
	GenicamNotFound,
	#[doc(alias = "ARV_DEVICE_ERROR_NO_STREAM_CHANNEL")]
	NoStreamChannel,
	#[doc(alias = "ARV_DEVICE_ERROR_NOT_CONTROLLER")]
	NotController,
	#[doc(alias = "ARV_DEVICE_ERROR_UNKNOWN")]
	Unknown,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for DeviceError {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"DeviceError::{}",
			match *self {
				Self::WrongFeature => "WrongFeature",
				Self::FeatureNotFound => "FeatureNotFound",
				Self::NotConnected => "NotConnected",
				Self::ProtocolError => "ProtocolError",
				Self::TransferError => "TransferError",
				Self::Timeout => "Timeout",
				Self::NotFound => "NotFound",
				Self::InvalidParameter => "InvalidParameter",
				Self::GenicamNotFound => "GenicamNotFound",
				Self::NoStreamChannel => "NoStreamChannel",
				Self::NotController => "NotController",
				Self::Unknown => "Unknown",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for DeviceError {
	type GlibType = ffi::ArvDeviceError;

	fn into_glib(self) -> ffi::ArvDeviceError {
		match self {
			Self::WrongFeature => ffi::ARV_DEVICE_ERROR_WRONG_FEATURE,
			Self::FeatureNotFound => ffi::ARV_DEVICE_ERROR_FEATURE_NOT_FOUND,
			Self::NotConnected => ffi::ARV_DEVICE_ERROR_NOT_CONNECTED,
			Self::ProtocolError => ffi::ARV_DEVICE_ERROR_PROTOCOL_ERROR,
			Self::TransferError => ffi::ARV_DEVICE_ERROR_TRANSFER_ERROR,
			Self::Timeout => ffi::ARV_DEVICE_ERROR_TIMEOUT,
			Self::NotFound => ffi::ARV_DEVICE_ERROR_NOT_FOUND,
			Self::InvalidParameter => ffi::ARV_DEVICE_ERROR_INVALID_PARAMETER,
			Self::GenicamNotFound => ffi::ARV_DEVICE_ERROR_GENICAM_NOT_FOUND,
			Self::NoStreamChannel => ffi::ARV_DEVICE_ERROR_NO_STREAM_CHANNEL,
			Self::NotController => ffi::ARV_DEVICE_ERROR_NOT_CONTROLLER,
			Self::Unknown => ffi::ARV_DEVICE_ERROR_UNKNOWN,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvDeviceError> for DeviceError {
	unsafe fn from_glib(value: ffi::ArvDeviceError) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_DEVICE_ERROR_WRONG_FEATURE => Self::WrongFeature,
			ffi::ARV_DEVICE_ERROR_FEATURE_NOT_FOUND => Self::FeatureNotFound,
			ffi::ARV_DEVICE_ERROR_NOT_CONNECTED => Self::NotConnected,
			ffi::ARV_DEVICE_ERROR_PROTOCOL_ERROR => Self::ProtocolError,
			ffi::ARV_DEVICE_ERROR_TRANSFER_ERROR => Self::TransferError,
			ffi::ARV_DEVICE_ERROR_TIMEOUT => Self::Timeout,
			ffi::ARV_DEVICE_ERROR_NOT_FOUND => Self::NotFound,
			ffi::ARV_DEVICE_ERROR_INVALID_PARAMETER => Self::InvalidParameter,
			ffi::ARV_DEVICE_ERROR_GENICAM_NOT_FOUND => Self::GenicamNotFound,
			ffi::ARV_DEVICE_ERROR_NO_STREAM_CHANNEL => Self::NoStreamChannel,
			ffi::ARV_DEVICE_ERROR_NOT_CONTROLLER => Self::NotController,
			ffi::ARV_DEVICE_ERROR_UNKNOWN => Self::Unknown,
			value => Self::__Unknown(value),
		}
	}
}

impl ErrorDomain for DeviceError {
	fn domain() -> Quark {
		skip_assert_initialized!();

		unsafe { from_glib(ffi::arv_device_error_quark()) }
	}

	fn code(self) -> i32 {
		self.into_glib()
	}

	fn from(code: i32) -> Option<Self> {
		skip_assert_initialized!();
		match code {
			ffi::ARV_DEVICE_ERROR_WRONG_FEATURE => Some(Self::WrongFeature),
			ffi::ARV_DEVICE_ERROR_FEATURE_NOT_FOUND => Some(Self::FeatureNotFound),
			ffi::ARV_DEVICE_ERROR_NOT_CONNECTED => Some(Self::NotConnected),
			ffi::ARV_DEVICE_ERROR_PROTOCOL_ERROR => Some(Self::ProtocolError),
			ffi::ARV_DEVICE_ERROR_TRANSFER_ERROR => Some(Self::TransferError),
			ffi::ARV_DEVICE_ERROR_TIMEOUT => Some(Self::Timeout),
			ffi::ARV_DEVICE_ERROR_NOT_FOUND => Some(Self::NotFound),
			ffi::ARV_DEVICE_ERROR_INVALID_PARAMETER => Some(Self::InvalidParameter),
			ffi::ARV_DEVICE_ERROR_GENICAM_NOT_FOUND => Some(Self::GenicamNotFound),
			ffi::ARV_DEVICE_ERROR_NO_STREAM_CHANNEL => Some(Self::NoStreamChannel),
			ffi::ARV_DEVICE_ERROR_NOT_CONTROLLER => Some(Self::NotController),
			ffi::ARV_DEVICE_ERROR_UNKNOWN => Some(Self::Unknown),
			value => Some(Self::__Unknown(value)),
		}
	}
}

impl StaticType for DeviceError {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_device_error_get_type()) }
	}
}

impl glib::value::ValueType for DeviceError {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DeviceError {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for DeviceError {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvDomNodeType")]
pub enum DomNodeType {
	#[doc(alias = "ARV_DOM_NODE_TYPE_ELEMENT_NODE")]
	ElementNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_ATTRIBUTE_NODE")]
	AttributeNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_TEXT_NODE")]
	TextNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_CDATA_SECTION_NODE")]
	CdataSectionNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_ENTITY_REFERENCE_NODE")]
	EntityReferenceNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_ENTITY_NODE")]
	EntityNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_PROCESSING_INSTRUCTION_NODE")]
	ProcessingInstructionNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_COMMENT_NODE")]
	CommentNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_DOCUMENT_NODE")]
	DocumentNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_DOCUMENT_TYPE_NODE")]
	DocumentTypeNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_DOCUMENT_FRAGMENT_NODE")]
	DocumentFragmentNode,
	#[doc(alias = "ARV_DOM_NODE_TYPE_NOTATION_NODE")]
	NotationNode,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for DomNodeType {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"DomNodeType::{}",
			match *self {
				Self::ElementNode => "ElementNode",
				Self::AttributeNode => "AttributeNode",
				Self::TextNode => "TextNode",
				Self::CdataSectionNode => "CdataSectionNode",
				Self::EntityReferenceNode => "EntityReferenceNode",
				Self::EntityNode => "EntityNode",
				Self::ProcessingInstructionNode => "ProcessingInstructionNode",
				Self::CommentNode => "CommentNode",
				Self::DocumentNode => "DocumentNode",
				Self::DocumentTypeNode => "DocumentTypeNode",
				Self::DocumentFragmentNode => "DocumentFragmentNode",
				Self::NotationNode => "NotationNode",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for DomNodeType {
	type GlibType = ffi::ArvDomNodeType;

	fn into_glib(self) -> ffi::ArvDomNodeType {
		match self {
			Self::ElementNode => ffi::ARV_DOM_NODE_TYPE_ELEMENT_NODE,
			Self::AttributeNode => ffi::ARV_DOM_NODE_TYPE_ATTRIBUTE_NODE,
			Self::TextNode => ffi::ARV_DOM_NODE_TYPE_TEXT_NODE,
			Self::CdataSectionNode => ffi::ARV_DOM_NODE_TYPE_CDATA_SECTION_NODE,
			Self::EntityReferenceNode => ffi::ARV_DOM_NODE_TYPE_ENTITY_REFERENCE_NODE,
			Self::EntityNode => ffi::ARV_DOM_NODE_TYPE_ENTITY_NODE,
			Self::ProcessingInstructionNode => ffi::ARV_DOM_NODE_TYPE_PROCESSING_INSTRUCTION_NODE,
			Self::CommentNode => ffi::ARV_DOM_NODE_TYPE_COMMENT_NODE,
			Self::DocumentNode => ffi::ARV_DOM_NODE_TYPE_DOCUMENT_NODE,
			Self::DocumentTypeNode => ffi::ARV_DOM_NODE_TYPE_DOCUMENT_TYPE_NODE,
			Self::DocumentFragmentNode => ffi::ARV_DOM_NODE_TYPE_DOCUMENT_FRAGMENT_NODE,
			Self::NotationNode => ffi::ARV_DOM_NODE_TYPE_NOTATION_NODE,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvDomNodeType> for DomNodeType {
	unsafe fn from_glib(value: ffi::ArvDomNodeType) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_DOM_NODE_TYPE_ELEMENT_NODE => Self::ElementNode,
			ffi::ARV_DOM_NODE_TYPE_ATTRIBUTE_NODE => Self::AttributeNode,
			ffi::ARV_DOM_NODE_TYPE_TEXT_NODE => Self::TextNode,
			ffi::ARV_DOM_NODE_TYPE_CDATA_SECTION_NODE => Self::CdataSectionNode,
			ffi::ARV_DOM_NODE_TYPE_ENTITY_REFERENCE_NODE => Self::EntityReferenceNode,
			ffi::ARV_DOM_NODE_TYPE_ENTITY_NODE => Self::EntityNode,
			ffi::ARV_DOM_NODE_TYPE_PROCESSING_INSTRUCTION_NODE => Self::ProcessingInstructionNode,
			ffi::ARV_DOM_NODE_TYPE_COMMENT_NODE => Self::CommentNode,
			ffi::ARV_DOM_NODE_TYPE_DOCUMENT_NODE => Self::DocumentNode,
			ffi::ARV_DOM_NODE_TYPE_DOCUMENT_TYPE_NODE => Self::DocumentTypeNode,
			ffi::ARV_DOM_NODE_TYPE_DOCUMENT_FRAGMENT_NODE => Self::DocumentFragmentNode,
			ffi::ARV_DOM_NODE_TYPE_NOTATION_NODE => Self::NotationNode,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for DomNodeType {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_dom_node_type_get_type()) }
	}
}

impl glib::value::ValueType for DomNodeType {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DomNodeType {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for DomNodeType {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Specifies access mode for feature nodes and registers.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcAccessMode")]
pub enum GcAccessMode {
	#[doc(alias = "ARV_GC_ACCESS_MODE_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_ACCESS_MODE_RO")]
	Ro,
	#[doc(alias = "ARV_GC_ACCESS_MODE_WO")]
	Wo,
	#[doc(alias = "ARV_GC_ACCESS_MODE_RW")]
	Rw,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcAccessMode {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcAccessMode::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Ro => "Ro",
				Self::Wo => "Wo",
				Self::Rw => "Rw",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcAccessMode {
	type GlibType = ffi::ArvGcAccessMode;

	fn into_glib(self) -> ffi::ArvGcAccessMode {
		match self {
			Self::Undefined => ffi::ARV_GC_ACCESS_MODE_UNDEFINED,
			Self::Ro => ffi::ARV_GC_ACCESS_MODE_RO,
			Self::Wo => ffi::ARV_GC_ACCESS_MODE_WO,
			Self::Rw => ffi::ARV_GC_ACCESS_MODE_RW,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcAccessMode> for GcAccessMode {
	unsafe fn from_glib(value: ffi::ArvGcAccessMode) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_ACCESS_MODE_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_ACCESS_MODE_RO => Self::Ro,
			ffi::ARV_GC_ACCESS_MODE_WO => Self::Wo,
			ffi::ARV_GC_ACCESS_MODE_RW => Self::Rw,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcAccessMode {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_access_mode_get_type()) }
	}
}

impl glib::value::ValueType for GcAccessMode {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcAccessMode {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcAccessMode {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Specifies caching mode for register values.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcCachable")]
pub enum GcCachable {
	#[doc(alias = "ARV_GC_CACHABLE_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_CACHABLE_NO_CACHE")]
	NoCache,
	#[doc(alias = "ARV_GC_CACHABLE_WRITE_THROUGH")]
	WriteThrough,
	#[doc(alias = "ARV_GC_CACHABLE_WRITE_AROUND")]
	WriteAround,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcCachable {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcCachable::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::NoCache => "NoCache",
				Self::WriteThrough => "WriteThrough",
				Self::WriteAround => "WriteAround",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcCachable {
	type GlibType = ffi::ArvGcCachable;

	fn into_glib(self) -> ffi::ArvGcCachable {
		match self {
			Self::Undefined => ffi::ARV_GC_CACHABLE_UNDEFINED,
			Self::NoCache => ffi::ARV_GC_CACHABLE_NO_CACHE,
			Self::WriteThrough => ffi::ARV_GC_CACHABLE_WRITE_THROUGH,
			Self::WriteAround => ffi::ARV_GC_CACHABLE_WRITE_AROUND,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcCachable> for GcCachable {
	unsafe fn from_glib(value: ffi::ArvGcCachable) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_CACHABLE_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_CACHABLE_NO_CACHE => Self::NoCache,
			ffi::ARV_GC_CACHABLE_WRITE_THROUGH => Self::WriteThrough,
			ffi::ARV_GC_CACHABLE_WRITE_AROUND => Self::WriteAround,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcCachable {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_cachable_get_type()) }
	}
}

impl glib::value::ValueType for GcCachable {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcCachable {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcCachable {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Number display notations for showing numbers in user interfaces.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcDisplayNotation")]
pub enum GcDisplayNotation {
	#[doc(alias = "ARV_GC_DISPLAY_NOTATION_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_DISPLAY_NOTATION_AUTOMATIC")]
	Automatic,
	#[doc(alias = "ARV_GC_DISPLAY_NOTATION_FIXED")]
	Fixed,
	#[doc(alias = "ARV_GC_DISPLAY_NOTATION_SCIENTIFIC")]
	Scientific,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcDisplayNotation {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcDisplayNotation::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Automatic => "Automatic",
				Self::Fixed => "Fixed",
				Self::Scientific => "Scientific",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcDisplayNotation {
	type GlibType = ffi::ArvGcDisplayNotation;

	fn into_glib(self) -> ffi::ArvGcDisplayNotation {
		match self {
			Self::Undefined => ffi::ARV_GC_DISPLAY_NOTATION_UNDEFINED,
			Self::Automatic => ffi::ARV_GC_DISPLAY_NOTATION_AUTOMATIC,
			Self::Fixed => ffi::ARV_GC_DISPLAY_NOTATION_FIXED,
			Self::Scientific => ffi::ARV_GC_DISPLAY_NOTATION_SCIENTIFIC,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcDisplayNotation> for GcDisplayNotation {
	unsafe fn from_glib(value: ffi::ArvGcDisplayNotation) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_DISPLAY_NOTATION_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_DISPLAY_NOTATION_AUTOMATIC => Self::Automatic,
			ffi::ARV_GC_DISPLAY_NOTATION_FIXED => Self::Fixed,
			ffi::ARV_GC_DISPLAY_NOTATION_SCIENTIFIC => Self::Scientific,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcDisplayNotation {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_display_notation_get_type()) }
	}
}

impl glib::value::ValueType for GcDisplayNotation {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcDisplayNotation {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcDisplayNotation {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcError")]
pub enum GcError {
	#[doc(alias = "ARV_GC_ERROR_PROPERTY_NOT_DEFINED")]
	PropertyNotDefined,
	#[doc(alias = "ARV_GC_ERROR_PVALUE_NOT_DEFINED")]
	PvalueNotDefined,
	#[doc(alias = "ARV_GC_ERROR_INVALID_PVALUE")]
	InvalidPvalue,
	#[doc(alias = "ARV_GC_ERROR_EMPTY_ENUMERATION")]
	EmptyEnumeration,
	#[doc(alias = "ARV_GC_ERROR_OUT_OF_RANGE")]
	OutOfRange,
	#[doc(alias = "ARV_GC_ERROR_NO_DEVICE_SET")]
	NoDeviceSet,
	#[doc(alias = "ARV_GC_ERROR_NO_EVENT_IMPLEMENTATION")]
	NoEventImplementation,
	#[doc(alias = "ARV_GC_ERROR_NODE_NOT_FOUND")]
	NodeNotFound,
	#[doc(alias = "ARV_GC_ERROR_ENUM_ENTRY_NOT_FOUND")]
	EnumEntryNotFound,
	#[doc(alias = "ARV_GC_ERROR_INVALID_LENGTH")]
	InvalidLength,
	#[doc(alias = "ARV_GC_ERROR_READ_ONLY")]
	ReadOnly,
	#[doc(alias = "ARV_GC_ERROR_SET_FROM_STRING_UNDEFINED")]
	SetFromStringUndefined,
	#[doc(alias = "ARV_GC_ERROR_GET_AS_STRING_UNDEFINED")]
	GetAsStringUndefined,
	#[doc(alias = "ARV_GC_ERROR_INVALID_BIT_RANGE")]
	InvalidBitRange,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcError {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcError::{}",
			match *self {
				Self::PropertyNotDefined => "PropertyNotDefined",
				Self::PvalueNotDefined => "PvalueNotDefined",
				Self::InvalidPvalue => "InvalidPvalue",
				Self::EmptyEnumeration => "EmptyEnumeration",
				Self::OutOfRange => "OutOfRange",
				Self::NoDeviceSet => "NoDeviceSet",
				Self::NoEventImplementation => "NoEventImplementation",
				Self::NodeNotFound => "NodeNotFound",
				Self::EnumEntryNotFound => "EnumEntryNotFound",
				Self::InvalidLength => "InvalidLength",
				Self::ReadOnly => "ReadOnly",
				Self::SetFromStringUndefined => "SetFromStringUndefined",
				Self::GetAsStringUndefined => "GetAsStringUndefined",
				Self::InvalidBitRange => "InvalidBitRange",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcError {
	type GlibType = ffi::ArvGcError;

	fn into_glib(self) -> ffi::ArvGcError {
		match self {
			Self::PropertyNotDefined => ffi::ARV_GC_ERROR_PROPERTY_NOT_DEFINED,
			Self::PvalueNotDefined => ffi::ARV_GC_ERROR_PVALUE_NOT_DEFINED,
			Self::InvalidPvalue => ffi::ARV_GC_ERROR_INVALID_PVALUE,
			Self::EmptyEnumeration => ffi::ARV_GC_ERROR_EMPTY_ENUMERATION,
			Self::OutOfRange => ffi::ARV_GC_ERROR_OUT_OF_RANGE,
			Self::NoDeviceSet => ffi::ARV_GC_ERROR_NO_DEVICE_SET,
			Self::NoEventImplementation => ffi::ARV_GC_ERROR_NO_EVENT_IMPLEMENTATION,
			Self::NodeNotFound => ffi::ARV_GC_ERROR_NODE_NOT_FOUND,
			Self::EnumEntryNotFound => ffi::ARV_GC_ERROR_ENUM_ENTRY_NOT_FOUND,
			Self::InvalidLength => ffi::ARV_GC_ERROR_INVALID_LENGTH,
			Self::ReadOnly => ffi::ARV_GC_ERROR_READ_ONLY,
			Self::SetFromStringUndefined => ffi::ARV_GC_ERROR_SET_FROM_STRING_UNDEFINED,
			Self::GetAsStringUndefined => ffi::ARV_GC_ERROR_GET_AS_STRING_UNDEFINED,
			Self::InvalidBitRange => ffi::ARV_GC_ERROR_INVALID_BIT_RANGE,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcError> for GcError {
	unsafe fn from_glib(value: ffi::ArvGcError) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_ERROR_PROPERTY_NOT_DEFINED => Self::PropertyNotDefined,
			ffi::ARV_GC_ERROR_PVALUE_NOT_DEFINED => Self::PvalueNotDefined,
			ffi::ARV_GC_ERROR_INVALID_PVALUE => Self::InvalidPvalue,
			ffi::ARV_GC_ERROR_EMPTY_ENUMERATION => Self::EmptyEnumeration,
			ffi::ARV_GC_ERROR_OUT_OF_RANGE => Self::OutOfRange,
			ffi::ARV_GC_ERROR_NO_DEVICE_SET => Self::NoDeviceSet,
			ffi::ARV_GC_ERROR_NO_EVENT_IMPLEMENTATION => Self::NoEventImplementation,
			ffi::ARV_GC_ERROR_NODE_NOT_FOUND => Self::NodeNotFound,
			ffi::ARV_GC_ERROR_ENUM_ENTRY_NOT_FOUND => Self::EnumEntryNotFound,
			ffi::ARV_GC_ERROR_INVALID_LENGTH => Self::InvalidLength,
			ffi::ARV_GC_ERROR_READ_ONLY => Self::ReadOnly,
			ffi::ARV_GC_ERROR_SET_FROM_STRING_UNDEFINED => Self::SetFromStringUndefined,
			ffi::ARV_GC_ERROR_GET_AS_STRING_UNDEFINED => Self::GetAsStringUndefined,
			ffi::ARV_GC_ERROR_INVALID_BIT_RANGE => Self::InvalidBitRange,
			value => Self::__Unknown(value),
		}
	}
}

impl ErrorDomain for GcError {
	fn domain() -> Quark {
		skip_assert_initialized!();

		unsafe { from_glib(ffi::arv_gc_error_quark()) }
	}

	fn code(self) -> i32 {
		self.into_glib()
	}

	fn from(code: i32) -> Option<Self> {
		skip_assert_initialized!();
		match code {
			ffi::ARV_GC_ERROR_PROPERTY_NOT_DEFINED => Some(Self::PropertyNotDefined),
			ffi::ARV_GC_ERROR_PVALUE_NOT_DEFINED => Some(Self::PvalueNotDefined),
			ffi::ARV_GC_ERROR_INVALID_PVALUE => Some(Self::InvalidPvalue),
			ffi::ARV_GC_ERROR_EMPTY_ENUMERATION => Some(Self::EmptyEnumeration),
			ffi::ARV_GC_ERROR_OUT_OF_RANGE => Some(Self::OutOfRange),
			ffi::ARV_GC_ERROR_NO_DEVICE_SET => Some(Self::NoDeviceSet),
			ffi::ARV_GC_ERROR_NO_EVENT_IMPLEMENTATION => Some(Self::NoEventImplementation),
			ffi::ARV_GC_ERROR_NODE_NOT_FOUND => Some(Self::NodeNotFound),
			ffi::ARV_GC_ERROR_ENUM_ENTRY_NOT_FOUND => Some(Self::EnumEntryNotFound),
			ffi::ARV_GC_ERROR_INVALID_LENGTH => Some(Self::InvalidLength),
			ffi::ARV_GC_ERROR_READ_ONLY => Some(Self::ReadOnly),
			ffi::ARV_GC_ERROR_SET_FROM_STRING_UNDEFINED => Some(Self::SetFromStringUndefined),
			ffi::ARV_GC_ERROR_GET_AS_STRING_UNDEFINED => Some(Self::GetAsStringUndefined),
			ffi::ARV_GC_ERROR_INVALID_BIT_RANGE => Some(Self::InvalidBitRange),
			value => Some(Self::__Unknown(value)),
		}
	}
}

impl StaticType for GcError {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_error_get_type()) }
	}
}

impl glib::value::ValueType for GcError {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcError {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcError {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Describes relationship between TO and FROM variables in Converter feature nodes.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcIsLinear")]
pub enum GcIsLinear {
	#[doc(alias = "ARV_GC_IS_LINEAR_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_IS_LINEAR_NO")]
	No,
	#[doc(alias = "ARV_GC_IS_LINEAR_YES")]
	Yes,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcIsLinear {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcIsLinear::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::No => "No",
				Self::Yes => "Yes",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcIsLinear {
	type GlibType = ffi::ArvGcIsLinear;

	fn into_glib(self) -> ffi::ArvGcIsLinear {
		match self {
			Self::Undefined => ffi::ARV_GC_IS_LINEAR_UNDEFINED,
			Self::No => ffi::ARV_GC_IS_LINEAR_NO,
			Self::Yes => ffi::ARV_GC_IS_LINEAR_YES,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcIsLinear> for GcIsLinear {
	unsafe fn from_glib(value: ffi::ArvGcIsLinear) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_IS_LINEAR_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_IS_LINEAR_NO => Self::No,
			ffi::ARV_GC_IS_LINEAR_YES => Self::Yes,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcIsLinear {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_is_linear_get_type()) }
	}
}

impl glib::value::ValueType for GcIsLinear {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcIsLinear {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcIsLinear {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Specifies feature node or register name space type. Standard name space features are listed in
/// Genicam materials. Any other vendor-specific features should use custom name space type.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcNameSpace")]
pub enum GcNameSpace {
	#[doc(alias = "ARV_GC_NAME_SPACE_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_NAME_SPACE_STANDARD")]
	Standard,
	#[doc(alias = "ARV_GC_NAME_SPACE_CUSTOM")]
	Custom,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcNameSpace {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcNameSpace::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Standard => "Standard",
				Self::Custom => "Custom",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcNameSpace {
	type GlibType = ffi::ArvGcNameSpace;

	fn into_glib(self) -> ffi::ArvGcNameSpace {
		match self {
			Self::Undefined => ffi::ARV_GC_NAME_SPACE_UNDEFINED,
			Self::Standard => ffi::ARV_GC_NAME_SPACE_STANDARD,
			Self::Custom => ffi::ARV_GC_NAME_SPACE_CUSTOM,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcNameSpace> for GcNameSpace {
	unsafe fn from_glib(value: ffi::ArvGcNameSpace) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_NAME_SPACE_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_NAME_SPACE_STANDARD => Self::Standard,
			ffi::ARV_GC_NAME_SPACE_CUSTOM => Self::Custom,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcNameSpace {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_name_space_get_type()) }
	}
}

impl glib::value::ValueType for GcNameSpace {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcNameSpace {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcNameSpace {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcPropertyNodeType")]
pub enum GcPropertyNodeType {
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_UNKNOWN")]
	Unknown,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_VALUE")]
	Value,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_ADDRESS")]
	Address,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_DESCRIPTION")]
	Description,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_VISIBILITY")]
	Visibility,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_TOOLTIP")]
	Tooltip,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NAME")]
	DisplayName,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_MINIMUM")]
	Minimum,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_MAXIMUM")]
	Maximum,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_SLOPE")]
	Slope,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_INCREMENT")]
	Increment,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_IS_LINEAR")]
	IsLinear,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_REPRESENTATION")]
	Representation,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NOTATION")]
	DisplayNotation,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_PRECISION")]
	DisplayPrecision,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_UNIT")]
	Unit,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_ON_VALUE")]
	OnValue,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_OFF_VALUE")]
	OffValue,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_LENGTH")]
	Length,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_FORMULA")]
	Formula,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_FORMULA_TO")]
	FormulaTo,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_FORMULA_FROM")]
	FormulaFrom,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_EXPRESSION")]
	Expression,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_CONSTANT")]
	Constant,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_ACCESS_MODE")]
	AccessMode,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_IMPOSED_ACCESS_MODE")]
	ImposedAccessMode,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_CACHABLE")]
	Cachable,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_POLLING_TIME")]
	PollingTime,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_ENDIANNESS")]
	Endianness,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_SIGN")]
	Sign,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_LSB")]
	Lsb,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_MSB")]
	Msb,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_BIT")]
	Bit,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_COMMAND_VALUE")]
	CommandValue,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_CHUNK_ID")]
	ChunkId,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_EVENT_ID")]
	EventId,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_VALUE_INDEXED")]
	ValueIndexed,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_VALUE_DEFAULT")]
	ValueDefault,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_STREAMABLE")]
	Streamable,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_UNKNONW")]
	PUnknonw,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_FEATURE")]
	PFeature,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_VALUE")]
	PValue,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_ADDRESS")]
	PAddress,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_IS_IMPLEMENTED")]
	PIsImplemented,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_IS_LOCKED")]
	PIsLocked,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_IS_AVAILABLE")]
	PIsAvailable,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_SELECTED")]
	PSelected,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_MINIMUM")]
	PMinimum,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_MAXIMUM")]
	PMaximum,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_INCREMENT")]
	PIncrement,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_INDEX")]
	PIndex,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_LENGTH")]
	PLength,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_PORT")]
	PPort,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_VARIABLE")]
	PVariable,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_INVALIDATOR")]
	PInvalidator,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_COMMAND_VALUE")]
	PCommandValue,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_INDEXED")]
	PValueIndexed,
	#[doc(alias = "ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_DEFAULT")]
	PValueDefault,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcPropertyNodeType {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcPropertyNodeType::{}",
			match *self {
				Self::Unknown => "Unknown",
				Self::Value => "Value",
				Self::Address => "Address",
				Self::Description => "Description",
				Self::Visibility => "Visibility",
				Self::Tooltip => "Tooltip",
				Self::DisplayName => "DisplayName",
				Self::Minimum => "Minimum",
				Self::Maximum => "Maximum",
				Self::Slope => "Slope",
				Self::Increment => "Increment",
				Self::IsLinear => "IsLinear",
				Self::Representation => "Representation",
				Self::DisplayNotation => "DisplayNotation",
				Self::DisplayPrecision => "DisplayPrecision",
				Self::Unit => "Unit",
				Self::OnValue => "OnValue",
				Self::OffValue => "OffValue",
				Self::Length => "Length",
				Self::Formula => "Formula",
				Self::FormulaTo => "FormulaTo",
				Self::FormulaFrom => "FormulaFrom",
				Self::Expression => "Expression",
				Self::Constant => "Constant",
				Self::AccessMode => "AccessMode",
				Self::ImposedAccessMode => "ImposedAccessMode",
				Self::Cachable => "Cachable",
				Self::PollingTime => "PollingTime",
				Self::Endianness => "Endianness",
				Self::Sign => "Sign",
				Self::Lsb => "Lsb",
				Self::Msb => "Msb",
				Self::Bit => "Bit",
				Self::CommandValue => "CommandValue",
				Self::ChunkId => "ChunkId",
				Self::EventId => "EventId",
				Self::ValueIndexed => "ValueIndexed",
				Self::ValueDefault => "ValueDefault",
				Self::Streamable => "Streamable",
				Self::PUnknonw => "PUnknonw",
				Self::PFeature => "PFeature",
				Self::PValue => "PValue",
				Self::PAddress => "PAddress",
				Self::PIsImplemented => "PIsImplemented",
				Self::PIsLocked => "PIsLocked",
				Self::PIsAvailable => "PIsAvailable",
				Self::PSelected => "PSelected",
				Self::PMinimum => "PMinimum",
				Self::PMaximum => "PMaximum",
				Self::PIncrement => "PIncrement",
				Self::PIndex => "PIndex",
				Self::PLength => "PLength",
				Self::PPort => "PPort",
				Self::PVariable => "PVariable",
				Self::PInvalidator => "PInvalidator",
				Self::PCommandValue => "PCommandValue",
				Self::PValueIndexed => "PValueIndexed",
				Self::PValueDefault => "PValueDefault",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcPropertyNodeType {
	type GlibType = ffi::ArvGcPropertyNodeType;

	fn into_glib(self) -> ffi::ArvGcPropertyNodeType {
		match self {
			Self::Unknown => ffi::ARV_GC_PROPERTY_NODE_TYPE_UNKNOWN,
			Self::Value => ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE,
			Self::Address => ffi::ARV_GC_PROPERTY_NODE_TYPE_ADDRESS,
			Self::Description => ffi::ARV_GC_PROPERTY_NODE_TYPE_DESCRIPTION,
			Self::Visibility => ffi::ARV_GC_PROPERTY_NODE_TYPE_VISIBILITY,
			Self::Tooltip => ffi::ARV_GC_PROPERTY_NODE_TYPE_TOOLTIP,
			Self::DisplayName => ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NAME,
			Self::Minimum => ffi::ARV_GC_PROPERTY_NODE_TYPE_MINIMUM,
			Self::Maximum => ffi::ARV_GC_PROPERTY_NODE_TYPE_MAXIMUM,
			Self::Slope => ffi::ARV_GC_PROPERTY_NODE_TYPE_SLOPE,
			Self::Increment => ffi::ARV_GC_PROPERTY_NODE_TYPE_INCREMENT,
			Self::IsLinear => ffi::ARV_GC_PROPERTY_NODE_TYPE_IS_LINEAR,
			Self::Representation => ffi::ARV_GC_PROPERTY_NODE_TYPE_REPRESENTATION,
			Self::DisplayNotation => ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NOTATION,
			Self::DisplayPrecision => ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_PRECISION,
			Self::Unit => ffi::ARV_GC_PROPERTY_NODE_TYPE_UNIT,
			Self::OnValue => ffi::ARV_GC_PROPERTY_NODE_TYPE_ON_VALUE,
			Self::OffValue => ffi::ARV_GC_PROPERTY_NODE_TYPE_OFF_VALUE,
			Self::Length => ffi::ARV_GC_PROPERTY_NODE_TYPE_LENGTH,
			Self::Formula => ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA,
			Self::FormulaTo => ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA_TO,
			Self::FormulaFrom => ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA_FROM,
			Self::Expression => ffi::ARV_GC_PROPERTY_NODE_TYPE_EXPRESSION,
			Self::Constant => ffi::ARV_GC_PROPERTY_NODE_TYPE_CONSTANT,
			Self::AccessMode => ffi::ARV_GC_PROPERTY_NODE_TYPE_ACCESS_MODE,
			Self::ImposedAccessMode => ffi::ARV_GC_PROPERTY_NODE_TYPE_IMPOSED_ACCESS_MODE,
			Self::Cachable => ffi::ARV_GC_PROPERTY_NODE_TYPE_CACHABLE,
			Self::PollingTime => ffi::ARV_GC_PROPERTY_NODE_TYPE_POLLING_TIME,
			Self::Endianness => ffi::ARV_GC_PROPERTY_NODE_TYPE_ENDIANNESS,
			Self::Sign => ffi::ARV_GC_PROPERTY_NODE_TYPE_SIGN,
			Self::Lsb => ffi::ARV_GC_PROPERTY_NODE_TYPE_LSB,
			Self::Msb => ffi::ARV_GC_PROPERTY_NODE_TYPE_MSB,
			Self::Bit => ffi::ARV_GC_PROPERTY_NODE_TYPE_BIT,
			Self::CommandValue => ffi::ARV_GC_PROPERTY_NODE_TYPE_COMMAND_VALUE,
			Self::ChunkId => ffi::ARV_GC_PROPERTY_NODE_TYPE_CHUNK_ID,
			Self::EventId => ffi::ARV_GC_PROPERTY_NODE_TYPE_EVENT_ID,
			Self::ValueIndexed => ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE_INDEXED,
			Self::ValueDefault => ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE_DEFAULT,
			Self::Streamable => ffi::ARV_GC_PROPERTY_NODE_TYPE_STREAMABLE,
			Self::PUnknonw => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_UNKNONW,
			Self::PFeature => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_FEATURE,
			Self::PValue => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE,
			Self::PAddress => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_ADDRESS,
			Self::PIsImplemented => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_IMPLEMENTED,
			Self::PIsLocked => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_LOCKED,
			Self::PIsAvailable => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_AVAILABLE,
			Self::PSelected => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_SELECTED,
			Self::PMinimum => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_MINIMUM,
			Self::PMaximum => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_MAXIMUM,
			Self::PIncrement => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INCREMENT,
			Self::PIndex => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INDEX,
			Self::PLength => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_LENGTH,
			Self::PPort => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_PORT,
			Self::PVariable => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VARIABLE,
			Self::PInvalidator => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INVALIDATOR,
			Self::PCommandValue => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_COMMAND_VALUE,
			Self::PValueIndexed => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_INDEXED,
			Self::PValueDefault => ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_DEFAULT,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcPropertyNodeType> for GcPropertyNodeType {
	unsafe fn from_glib(value: ffi::ArvGcPropertyNodeType) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_PROPERTY_NODE_TYPE_UNKNOWN => Self::Unknown,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE => Self::Value,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_ADDRESS => Self::Address,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_DESCRIPTION => Self::Description,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_VISIBILITY => Self::Visibility,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_TOOLTIP => Self::Tooltip,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NAME => Self::DisplayName,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_MINIMUM => Self::Minimum,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_MAXIMUM => Self::Maximum,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_SLOPE => Self::Slope,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_INCREMENT => Self::Increment,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_IS_LINEAR => Self::IsLinear,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_REPRESENTATION => Self::Representation,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_NOTATION => Self::DisplayNotation,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_DISPLAY_PRECISION => Self::DisplayPrecision,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_UNIT => Self::Unit,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_ON_VALUE => Self::OnValue,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_OFF_VALUE => Self::OffValue,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_LENGTH => Self::Length,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA => Self::Formula,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA_TO => Self::FormulaTo,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_FORMULA_FROM => Self::FormulaFrom,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_EXPRESSION => Self::Expression,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_CONSTANT => Self::Constant,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_ACCESS_MODE => Self::AccessMode,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_IMPOSED_ACCESS_MODE => Self::ImposedAccessMode,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_CACHABLE => Self::Cachable,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_POLLING_TIME => Self::PollingTime,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_ENDIANNESS => Self::Endianness,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_SIGN => Self::Sign,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_LSB => Self::Lsb,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_MSB => Self::Msb,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_BIT => Self::Bit,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_COMMAND_VALUE => Self::CommandValue,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_CHUNK_ID => Self::ChunkId,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_EVENT_ID => Self::EventId,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE_INDEXED => Self::ValueIndexed,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_VALUE_DEFAULT => Self::ValueDefault,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_STREAMABLE => Self::Streamable,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_UNKNONW => Self::PUnknonw,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_FEATURE => Self::PFeature,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE => Self::PValue,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_ADDRESS => Self::PAddress,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_IMPLEMENTED => Self::PIsImplemented,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_LOCKED => Self::PIsLocked,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_IS_AVAILABLE => Self::PIsAvailable,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_SELECTED => Self::PSelected,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_MINIMUM => Self::PMinimum,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_MAXIMUM => Self::PMaximum,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INCREMENT => Self::PIncrement,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INDEX => Self::PIndex,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_LENGTH => Self::PLength,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_PORT => Self::PPort,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VARIABLE => Self::PVariable,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_INVALIDATOR => Self::PInvalidator,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_COMMAND_VALUE => Self::PCommandValue,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_INDEXED => Self::PValueIndexed,
			ffi::ARV_GC_PROPERTY_NODE_TYPE_P_VALUE_DEFAULT => Self::PValueDefault,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcPropertyNodeType {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_property_node_type_get_type()) }
	}
}

impl glib::value::ValueType for GcPropertyNodeType {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcPropertyNodeType {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcPropertyNodeType {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Number representation formats.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcRepresentation")]
pub enum GcRepresentation {
	#[doc(alias = "ARV_GC_REPRESENTATION_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_REPRESENTATION_LINEAR")]
	Linear,
	#[doc(alias = "ARV_GC_REPRESENTATION_LOGARITHMIC")]
	Logarithmic,
	#[doc(alias = "ARV_GC_REPRESENTATION_BOOLEAN")]
	Boolean,
	#[doc(alias = "ARV_GC_REPRESENTATION_PURE_NUMBER")]
	PureNumber,
	#[doc(alias = "ARV_GC_REPRESENTATION_HEX_NUMBER")]
	HexNumber,
	#[doc(alias = "ARV_GC_REPRESENTATION_IPV4_ADDRESS")]
	Ipv4Address,
	#[doc(alias = "ARV_GC_REPRESENTATION_MAC_ADDRESS")]
	MacAddress,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcRepresentation {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcRepresentation::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Linear => "Linear",
				Self::Logarithmic => "Logarithmic",
				Self::Boolean => "Boolean",
				Self::PureNumber => "PureNumber",
				Self::HexNumber => "HexNumber",
				Self::Ipv4Address => "Ipv4Address",
				Self::MacAddress => "MacAddress",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcRepresentation {
	type GlibType = ffi::ArvGcRepresentation;

	fn into_glib(self) -> ffi::ArvGcRepresentation {
		match self {
			Self::Undefined => ffi::ARV_GC_REPRESENTATION_UNDEFINED,
			Self::Linear => ffi::ARV_GC_REPRESENTATION_LINEAR,
			Self::Logarithmic => ffi::ARV_GC_REPRESENTATION_LOGARITHMIC,
			Self::Boolean => ffi::ARV_GC_REPRESENTATION_BOOLEAN,
			Self::PureNumber => ffi::ARV_GC_REPRESENTATION_PURE_NUMBER,
			Self::HexNumber => ffi::ARV_GC_REPRESENTATION_HEX_NUMBER,
			Self::Ipv4Address => ffi::ARV_GC_REPRESENTATION_IPV4_ADDRESS,
			Self::MacAddress => ffi::ARV_GC_REPRESENTATION_MAC_ADDRESS,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcRepresentation> for GcRepresentation {
	unsafe fn from_glib(value: ffi::ArvGcRepresentation) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_REPRESENTATION_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_REPRESENTATION_LINEAR => Self::Linear,
			ffi::ARV_GC_REPRESENTATION_LOGARITHMIC => Self::Logarithmic,
			ffi::ARV_GC_REPRESENTATION_BOOLEAN => Self::Boolean,
			ffi::ARV_GC_REPRESENTATION_PURE_NUMBER => Self::PureNumber,
			ffi::ARV_GC_REPRESENTATION_HEX_NUMBER => Self::HexNumber,
			ffi::ARV_GC_REPRESENTATION_IPV4_ADDRESS => Self::Ipv4Address,
			ffi::ARV_GC_REPRESENTATION_MAC_ADDRESS => Self::MacAddress,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcRepresentation {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_representation_get_type()) }
	}
}

impl glib::value::ValueType for GcRepresentation {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcRepresentation {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcRepresentation {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Specifies signedness of integer registers. Per standard Genicam internally uses signed 64-bit
/// signed integers for representing all integer registers. Therefore unsigned 64-bit integers are
/// not available.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcSignedness")]
pub enum GcSignedness {
	#[doc(alias = "ARV_GC_SIGNEDNESS_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_SIGNEDNESS_SIGNED")]
	Signed,
	#[doc(alias = "ARV_GC_SIGNEDNESS_UNSIGNED")]
	Unsigned,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcSignedness {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcSignedness::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Signed => "Signed",
				Self::Unsigned => "Unsigned",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcSignedness {
	type GlibType = ffi::ArvGcSignedness;

	fn into_glib(self) -> ffi::ArvGcSignedness {
		match self {
			Self::Undefined => ffi::ARV_GC_SIGNEDNESS_UNDEFINED,
			Self::Signed => ffi::ARV_GC_SIGNEDNESS_SIGNED,
			Self::Unsigned => ffi::ARV_GC_SIGNEDNESS_UNSIGNED,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcSignedness> for GcSignedness {
	unsafe fn from_glib(value: ffi::ArvGcSignedness) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_SIGNEDNESS_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_SIGNEDNESS_SIGNED => Self::Signed,
			ffi::ARV_GC_SIGNEDNESS_UNSIGNED => Self::Unsigned,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcSignedness {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_signedness_get_type()) }
	}
}

impl glib::value::ValueType for GcSignedness {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcSignedness {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcSignedness {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Specifies feature node recommended visibility in user interfaces.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGcVisibility")]
pub enum GcVisibility {
	#[doc(alias = "ARV_GC_VISIBILITY_UNDEFINED")]
	Undefined,
	#[doc(alias = "ARV_GC_VISIBILITY_INVISIBLE")]
	Invisible,
	#[doc(alias = "ARV_GC_VISIBILITY_GURU")]
	Guru,
	#[doc(alias = "ARV_GC_VISIBILITY_EXPERT")]
	Expert,
	#[doc(alias = "ARV_GC_VISIBILITY_BEGINNER")]
	Beginner,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GcVisibility {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GcVisibility::{}",
			match *self {
				Self::Undefined => "Undefined",
				Self::Invisible => "Invisible",
				Self::Guru => "Guru",
				Self::Expert => "Expert",
				Self::Beginner => "Beginner",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GcVisibility {
	type GlibType = ffi::ArvGcVisibility;

	fn into_glib(self) -> ffi::ArvGcVisibility {
		match self {
			Self::Undefined => ffi::ARV_GC_VISIBILITY_UNDEFINED,
			Self::Invisible => ffi::ARV_GC_VISIBILITY_INVISIBLE,
			Self::Guru => ffi::ARV_GC_VISIBILITY_GURU,
			Self::Expert => ffi::ARV_GC_VISIBILITY_EXPERT,
			Self::Beginner => ffi::ARV_GC_VISIBILITY_BEGINNER,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGcVisibility> for GcVisibility {
	unsafe fn from_glib(value: ffi::ArvGcVisibility) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GC_VISIBILITY_UNDEFINED => Self::Undefined,
			ffi::ARV_GC_VISIBILITY_INVISIBLE => Self::Invisible,
			ffi::ARV_GC_VISIBILITY_GURU => Self::Guru,
			ffi::ARV_GC_VISIBILITY_EXPERT => Self::Expert,
			ffi::ARV_GC_VISIBILITY_BEGINNER => Self::Beginner,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GcVisibility {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gc_visibility_get_type()) }
	}
}

impl glib::value::ValueType for GcVisibility {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GcVisibility {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GcVisibility {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGvPacketSizeAdjustment")]
pub enum GvPacketSizeAdjustment {
	#[doc(alias = "ARV_GV_PACKET_SIZE_ADJUSTMENT_NEVER")]
	Never,
	#[doc(alias = "ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE_ONCE")]
	OnFailureOnce,
	#[doc(alias = "ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE")]
	OnFailure,
	#[doc(alias = "ARV_GV_PACKET_SIZE_ADJUSTMENT_ONCE")]
	Once,
	#[doc(alias = "ARV_GV_PACKET_SIZE_ADJUSTMENT_ALWAYS")]
	Always,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GvPacketSizeAdjustment {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GvPacketSizeAdjustment::{}",
			match *self {
				Self::Never => "Never",
				Self::OnFailureOnce => "OnFailureOnce",
				Self::OnFailure => "OnFailure",
				Self::Once => "Once",
				Self::Always => "Always",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GvPacketSizeAdjustment {
	type GlibType = ffi::ArvGvPacketSizeAdjustment;

	fn into_glib(self) -> ffi::ArvGvPacketSizeAdjustment {
		match self {
			Self::Never => ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_NEVER,
			Self::OnFailureOnce => ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE_ONCE,
			Self::OnFailure => ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE,
			Self::Once => ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ONCE,
			Self::Always => ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ALWAYS,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGvPacketSizeAdjustment> for GvPacketSizeAdjustment {
	unsafe fn from_glib(value: ffi::ArvGvPacketSizeAdjustment) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_NEVER => Self::Never,
			ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE_ONCE => Self::OnFailureOnce,
			ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ON_FAILURE => Self::OnFailure,
			ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ONCE => Self::Once,
			ffi::ARV_GV_PACKET_SIZE_ADJUSTMENT_ALWAYS => Self::Always,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GvPacketSizeAdjustment {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gv_packet_size_adjustment_get_type()) }
	}
}

impl glib::value::ValueType for GvPacketSizeAdjustment {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GvPacketSizeAdjustment {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GvPacketSizeAdjustment {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGvStreamOption")]
pub enum GvStreamOption {
	#[doc(alias = "ARV_GV_STREAM_OPTION_NONE")]
	None,
	#[doc(alias = "ARV_GV_STREAM_OPTION_PACKET_SOCKET_DISABLED")]
	PacketSocketDisabled,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GvStreamOption {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GvStreamOption::{}",
			match *self {
				Self::None => "None",
				Self::PacketSocketDisabled => "PacketSocketDisabled",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GvStreamOption {
	type GlibType = ffi::ArvGvStreamOption;

	fn into_glib(self) -> ffi::ArvGvStreamOption {
		match self {
			Self::None => ffi::ARV_GV_STREAM_OPTION_NONE,
			Self::PacketSocketDisabled => ffi::ARV_GV_STREAM_OPTION_PACKET_SOCKET_DISABLED,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGvStreamOption> for GvStreamOption {
	unsafe fn from_glib(value: ffi::ArvGvStreamOption) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GV_STREAM_OPTION_NONE => Self::None,
			ffi::ARV_GV_STREAM_OPTION_PACKET_SOCKET_DISABLED => Self::PacketSocketDisabled,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GvStreamOption {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gv_stream_option_get_type()) }
	}
}

impl glib::value::ValueType for GvStreamOption {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GvStreamOption {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GvStreamOption {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGvStreamPacketResend")]
pub enum GvStreamPacketResend {
	#[doc(alias = "ARV_GV_STREAM_PACKET_RESEND_NEVER")]
	Never,
	#[doc(alias = "ARV_GV_STREAM_PACKET_RESEND_ALWAYS")]
	Always,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GvStreamPacketResend {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GvStreamPacketResend::{}",
			match *self {
				Self::Never => "Never",
				Self::Always => "Always",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GvStreamPacketResend {
	type GlibType = ffi::ArvGvStreamPacketResend;

	fn into_glib(self) -> ffi::ArvGvStreamPacketResend {
		match self {
			Self::Never => ffi::ARV_GV_STREAM_PACKET_RESEND_NEVER,
			Self::Always => ffi::ARV_GV_STREAM_PACKET_RESEND_ALWAYS,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGvStreamPacketResend> for GvStreamPacketResend {
	unsafe fn from_glib(value: ffi::ArvGvStreamPacketResend) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GV_STREAM_PACKET_RESEND_NEVER => Self::Never,
			ffi::ARV_GV_STREAM_PACKET_RESEND_ALWAYS => Self::Always,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GvStreamPacketResend {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gv_stream_packet_resend_get_type()) }
	}
}

impl glib::value::ValueType for GvStreamPacketResend {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GvStreamPacketResend {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GvStreamPacketResend {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvGvStreamSocketBuffer")]
pub enum GvStreamSocketBuffer {
	#[doc(alias = "ARV_GV_STREAM_SOCKET_BUFFER_FIXED")]
	Fixed,
	#[doc(alias = "ARV_GV_STREAM_SOCKET_BUFFER_AUTO")]
	Auto,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for GvStreamSocketBuffer {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"GvStreamSocketBuffer::{}",
			match *self {
				Self::Fixed => "Fixed",
				Self::Auto => "Auto",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for GvStreamSocketBuffer {
	type GlibType = ffi::ArvGvStreamSocketBuffer;

	fn into_glib(self) -> ffi::ArvGvStreamSocketBuffer {
		match self {
			Self::Fixed => ffi::ARV_GV_STREAM_SOCKET_BUFFER_FIXED,
			Self::Auto => ffi::ARV_GV_STREAM_SOCKET_BUFFER_AUTO,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvGvStreamSocketBuffer> for GvStreamSocketBuffer {
	unsafe fn from_glib(value: ffi::ArvGvStreamSocketBuffer) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_GV_STREAM_SOCKET_BUFFER_FIXED => Self::Fixed,
			ffi::ARV_GV_STREAM_SOCKET_BUFFER_AUTO => Self::Auto,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for GvStreamSocketBuffer {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_gv_stream_socket_buffer_get_type()) }
	}
}

impl glib::value::ValueType for GvStreamSocketBuffer {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GvStreamSocketBuffer {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for GvStreamSocketBuffer {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvRegisterCachePolicy")]
pub enum RegisterCachePolicy {
	#[doc(alias = "ARV_REGISTER_CACHE_POLICY_DISABLE")]
	Disable,
	#[doc(alias = "ARV_REGISTER_CACHE_POLICY_ENABLE")]
	Enable,
	#[doc(alias = "ARV_REGISTER_CACHE_POLICY_DEBUG")]
	Debug,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for RegisterCachePolicy {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"RegisterCachePolicy::{}",
			match *self {
				Self::Disable => "Disable",
				Self::Enable => "Enable",
				Self::Debug => "Debug",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for RegisterCachePolicy {
	type GlibType = ffi::ArvRegisterCachePolicy;

	fn into_glib(self) -> ffi::ArvRegisterCachePolicy {
		match self {
			Self::Disable => ffi::ARV_REGISTER_CACHE_POLICY_DISABLE,
			Self::Enable => ffi::ARV_REGISTER_CACHE_POLICY_ENABLE,
			Self::Debug => ffi::ARV_REGISTER_CACHE_POLICY_DEBUG,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvRegisterCachePolicy> for RegisterCachePolicy {
	unsafe fn from_glib(value: ffi::ArvRegisterCachePolicy) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_REGISTER_CACHE_POLICY_DISABLE => Self::Disable,
			ffi::ARV_REGISTER_CACHE_POLICY_ENABLE => Self::Enable,
			ffi::ARV_REGISTER_CACHE_POLICY_DEBUG => Self::Debug,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for RegisterCachePolicy {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_register_cache_policy_get_type()) }
	}
}

impl glib::value::ValueType for RegisterCachePolicy {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RegisterCachePolicy {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for RegisterCachePolicy {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

/// Describes when the stream callback is called.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvStreamCallbackType")]
pub enum StreamCallbackType {
	#[doc(alias = "ARV_STREAM_CALLBACK_TYPE_INIT")]
	Init,
	#[doc(alias = "ARV_STREAM_CALLBACK_TYPE_EXIT")]
	Exit,
	#[doc(alias = "ARV_STREAM_CALLBACK_TYPE_START_BUFFER")]
	StartBuffer,
	#[doc(alias = "ARV_STREAM_CALLBACK_TYPE_BUFFER_DONE")]
	BufferDone,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for StreamCallbackType {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"StreamCallbackType::{}",
			match *self {
				Self::Init => "Init",
				Self::Exit => "Exit",
				Self::StartBuffer => "StartBuffer",
				Self::BufferDone => "BufferDone",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for StreamCallbackType {
	type GlibType = ffi::ArvStreamCallbackType;

	fn into_glib(self) -> ffi::ArvStreamCallbackType {
		match self {
			Self::Init => ffi::ARV_STREAM_CALLBACK_TYPE_INIT,
			Self::Exit => ffi::ARV_STREAM_CALLBACK_TYPE_EXIT,
			Self::StartBuffer => ffi::ARV_STREAM_CALLBACK_TYPE_START_BUFFER,
			Self::BufferDone => ffi::ARV_STREAM_CALLBACK_TYPE_BUFFER_DONE,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvStreamCallbackType> for StreamCallbackType {
	unsafe fn from_glib(value: ffi::ArvStreamCallbackType) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_STREAM_CALLBACK_TYPE_INIT => Self::Init,
			ffi::ARV_STREAM_CALLBACK_TYPE_EXIT => Self::Exit,
			ffi::ARV_STREAM_CALLBACK_TYPE_START_BUFFER => Self::StartBuffer,
			ffi::ARV_STREAM_CALLBACK_TYPE_BUFFER_DONE => Self::BufferDone,
			value => Self::__Unknown(value),
		}
	}
}

impl StaticType for StreamCallbackType {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_stream_callback_type_get_type()) }
	}
}

impl glib::value::ValueType for StreamCallbackType {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StreamCallbackType {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for StreamCallbackType {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "ArvXmlSchemaError")]
pub enum XmlSchemaError {
	#[doc(alias = "ARV_XML_SCHEMA_ERROR_INVALID_STRUCTURE")]
	Structure,
	#[doc(hidden)]
	__Unknown(i32),
}

impl fmt::Display for XmlSchemaError {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		write!(
			f,
			"XmlSchemaError::{}",
			match *self {
				Self::Structure => "Structure",
				_ => "Unknown",
			}
		)
	}
}

#[doc(hidden)]
impl IntoGlib for XmlSchemaError {
	type GlibType = ffi::ArvXmlSchemaError;

	fn into_glib(self) -> ffi::ArvXmlSchemaError {
		match self {
			Self::Structure => ffi::ARV_XML_SCHEMA_ERROR_INVALID_STRUCTURE,
			Self::__Unknown(value) => value,
		}
	}
}

#[doc(hidden)]
impl FromGlib<ffi::ArvXmlSchemaError> for XmlSchemaError {
	unsafe fn from_glib(value: ffi::ArvXmlSchemaError) -> Self {
		skip_assert_initialized!();
		match value {
			ffi::ARV_XML_SCHEMA_ERROR_INVALID_STRUCTURE => Self::Structure,
			value => Self::__Unknown(value),
		}
	}
}

impl ErrorDomain for XmlSchemaError {
	fn domain() -> Quark {
		skip_assert_initialized!();

		unsafe { from_glib(ffi::arv_xml_schema_error_quark()) }
	}

	fn code(self) -> i32 {
		self.into_glib()
	}

	fn from(code: i32) -> Option<Self> {
		skip_assert_initialized!();
		match code {
			ffi::ARV_XML_SCHEMA_ERROR_INVALID_STRUCTURE => Some(Self::Structure),
			value => Some(Self::__Unknown(value)),
		}
	}
}

impl StaticType for XmlSchemaError {
	fn static_type() -> Type {
		unsafe { from_glib(ffi::arv_xml_schema_error_get_type()) }
	}
}

impl glib::value::ValueType for XmlSchemaError {
	type Type = Self;
}

unsafe impl<'a> FromValue<'a> for XmlSchemaError {
	type Checker = glib::value::GenericValueTypeChecker<Self>;

	unsafe fn from_value(value: &'a glib::Value) -> Self {
		skip_assert_initialized!();
		from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
	}
}

impl ToValue for XmlSchemaError {
	fn to_value(&self) -> glib::Value {
		let mut value = glib::Value::for_value_type::<Self>();
		unsafe {
			glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
		}
		value
	}

	fn value_type(&self) -> glib::Type {
		Self::static_type()
	}
}
