# aravis

This crate contains (mostly) safe bindings to the [Aravis][aravis] library.
The bindings are mostly auto-generated with the [`gir`][gir-tool] tool from the [gtk-rs][gtk-rs] project.

This crate currently targets version 0.8.14 of the Aravis library.

The autogenerated API uses extension traits to implement methods for many structs.
This is done by the `gir` tool to emulate class inheritance.
Practically, this means that you should also look the [`CameraExt`] trait if you want to know what you can do with a [`Camera`].

You can import the prelude to bring all available extension traits in scope:
```rust
use aravis::prelude::*;
```

## Migrating from 0.6
The API was regenerated with a new version of the `gir` tool.
As a result, the public API has changed a bit:
* Getters no-longer have a `get_` prefix, so a function that was called `get_foo()` is now simply called `foo()`.
* Methods for classes without subclasses no-longer live in `*Ext` traits.
  For example, this means that all methods for [`Buffer`] objects are now directly implemented on the `Buffer` struct.
  This mostly means you can just remove the import of traits that no longer exist.

## Documentation copyright
This documentation constist mainly of original documentation of the Aravis project.
The copyright and license of the Aravis project apply to those parts.
The [full original documentation][aravis-docs] is also available online and might help if the translation to Rust made things unclear.

[aravis]: https://github.com/AravisProject/aravis
[aravis-docs]: https://aravisproject.github.io/docs/aravis-0.8/
[gir-tool]: https://github.com/gtk-rs/gir
[gtk-rs]: https://gtk-rs.org/

[`Buffer`]: https://docs.rs/aravis/latest/aravis/struct.Buffer.html
[`Camera`]: https://docs.rs/aravis/latest/aravis/struct.Camera.html
[`CameraExt`]: https://docs.rs/aravis/latest/aravis/trait.CameraExt.html
