// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::Device;
use glib::object::Cast;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
	#[doc(alias = "ArvUvDevice")]
	pub struct UvDevice(Object<ffi::ArvUvDevice, ffi::ArvUvDeviceClass>) @extends Device;

	match fn {
		type_ => || ffi::arv_uv_device_get_type(),
	}
}

impl UvDevice {
	/// ## `vendor`
	/// USB3 vendor string
	/// ## `product`
	/// USB3 product string
	/// ## `serial_number`
	/// device serial number
	///
	/// # Returns
	///
	/// a newly created [`Device`][crate::Device] using USB3 based protocol
	#[doc(alias = "arv_uv_device_new")]
	pub fn new(vendor: &str, product: &str, serial_number: &str) -> Result<UvDevice, glib::Error> {
		assert_initialized_main_thread!();
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_uv_device_new(
				vendor.to_glib_none().0,
				product.to_glib_none().0,
				serial_number.to_glib_none().0,
				&mut error,
			);
			if error.is_null() {
				Ok(Device::from_glib_full(ret).unsafe_cast())
			} else {
				Err(from_glib_full(error))
			}
		}
	}
}

unsafe impl Send for UvDevice {}

impl fmt::Display for UvDevice {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("UvDevice")
	}
}
