// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::Device;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
	#[doc(alias = "ArvInterface")]
	pub struct Interface(Object<ffi::ArvInterface, ffi::ArvInterfaceClass>);

	match fn {
		type_ => || ffi::arv_interface_get_type(),
	}
}

unsafe impl Send for Interface {}

pub const NONE_INTERFACE: Option<&Interface> = None;

/// Trait containing all [`struct@Interface`] methods.
///
/// # Implementors
///
/// [`FakeInterface`][struct@crate::FakeInterface], [`GvInterface`][struct@crate::GvInterface], [`Interface`][struct@crate::Interface], [`UvInterface`][struct@crate::UvInterface]
pub trait InterfaceExt: 'static {
	/// queries the device address (IP address in the case of an ethernet camera). Useful
	/// for constructing manual connections to devices using [`GvDevice::new()`][crate::GvDevice::new()]
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// the device address
	#[doc(alias = "arv_interface_get_device_address")]
	#[doc(alias = "get_device_address")]
	fn device_address(&self, index: u32) -> Option<glib::GString>;

	/// Queries the unique device id corresponding to index. Prior to this
	/// call the [`update_device_list()`][Self::update_device_list()] function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// a unique device id
	#[doc(alias = "arv_interface_get_device_id")]
	#[doc(alias = "get_device_id")]
	fn device_id(&self, index: u32) -> Option<glib::GString>;

	/// Queries the device model.
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// the device model, NULL on error
	#[doc(alias = "arv_interface_get_device_model")]
	#[doc(alias = "get_device_model")]
	fn device_model(&self, index: u32) -> Option<glib::GString>;

	/// Queries the physical device id corresponding to index such
	/// as the MAC address for Ethernet based devices, bus id for PCI,
	/// USB or Firewire based devices.
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// a physical device id
	#[doc(alias = "arv_interface_get_device_physical_id")]
	#[doc(alias = "get_device_physical_id")]
	fn device_physical_id(&self, index: u32) -> Option<glib::GString>;

	/// Queries the device protocol. Possible values are 'USB3Vision', 'GigEVision'
	/// and 'Fake'.
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// the device protocol as a string, NULL on error
	#[doc(alias = "arv_interface_get_device_protocol")]
	#[doc(alias = "get_device_protocol")]
	fn device_protocol(&self, index: u32) -> Option<glib::GString>;

	/// Queries the device serial.
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// the device serial, NULL on error
	#[doc(alias = "arv_interface_get_device_serial_nbr")]
	#[doc(alias = "get_device_serial_nbr")]
	fn device_serial_nbr(&self, index: u32) -> Option<glib::GString>;

	/// Queries the device vendor.
	///
	/// Prior to this call the [`update_device_list()`][Self::update_device_list()]
	/// function must be called.
	/// ## `index`
	/// device index
	///
	/// # Returns
	///
	/// the device vendor, NULL on error
	#[doc(alias = "arv_interface_get_device_vendor")]
	#[doc(alias = "get_device_vendor")]
	fn device_vendor(&self, index: u32) -> Option<glib::GString>;

	/// Queries the number of available devices on this interface. Prior to this
	/// call the [`update_device_list()`][Self::update_device_list()] function must be called. The list content will not
	/// change until the next call of the update function.
	///
	/// # Returns
	///
	/// the number of available devices
	#[doc(alias = "arv_interface_get_n_devices")]
	#[doc(alias = "get_n_devices")]
	fn n_devices(&self) -> u32;

	/// Creates a new [`Device`][crate::Device] object corresponding to the given device id string.
	/// The first available device is returned if `device_id` is [`None`].
	/// ## `device_id`
	/// device unique id
	///
	/// # Returns
	///
	/// a new [`Device`][crate::Device]
	#[doc(alias = "arv_interface_open_device")]
	fn open_device(&self, device_id: Option<&str>) -> Result<Device, glib::Error>;

	/// Updates the internal list of available devices. This may change the
	/// connection between a list index and a device ID.
	#[doc(alias = "arv_interface_update_device_list")]
	fn update_device_list(&self);
}

impl<O: IsA<Interface>> InterfaceExt for O {
	fn device_address(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_address(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_id(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_id(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_model(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_model(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_physical_id(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_physical_id(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_protocol(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_protocol(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_serial_nbr(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_serial_nbr(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn device_vendor(&self, index: u32) -> Option<glib::GString> {
		unsafe {
			from_glib_none(ffi::arv_interface_get_device_vendor(
				self.as_ref().to_glib_none().0,
				index,
			))
		}
	}

	fn n_devices(&self) -> u32 {
		unsafe { ffi::arv_interface_get_n_devices(self.as_ref().to_glib_none().0) }
	}

	fn open_device(&self, device_id: Option<&str>) -> Result<Device, glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_interface_open_device(
				self.as_ref().to_glib_none().0,
				device_id.to_glib_none().0,
				&mut error,
			);
			if error.is_null() {
				Ok(from_glib_full(ret))
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	fn update_device_list(&self) {
		unsafe {
			ffi::arv_interface_update_device_list(self.as_ref().to_glib_none().0);
		}
	}
}

impl fmt::Display for Interface {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("Interface")
	}
}
