// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::DomElement;
use crate::DomNode;
use crate::GcFeatureNode;
use crate::GcNode;
use glib::object::Cast;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
	#[doc(alias = "ArvGcRegisterDescriptionNode")]
	pub struct GcRegisterDescriptionNode(Object<ffi::ArvGcRegisterDescriptionNode, ffi::ArvGcRegisterDescriptionNodeClass>) @extends GcFeatureNode, GcNode, DomElement, DomNode;

	match fn {
		type_ => || ffi::arv_gc_register_description_node_get_type(),
	}
}

impl GcRegisterDescriptionNode {
	#[doc(alias = "arv_gc_register_description_node_new")]
	pub fn new() -> GcRegisterDescriptionNode {
		assert_initialized_main_thread!();
		unsafe { GcNode::from_glib_full(ffi::arv_gc_register_description_node_new()).unsafe_cast() }
	}

	/// Checks if the Genicam document version is higher or equal to the given version.
	/// ## `required_major`
	/// required major version number
	/// ## `required_minor`
	/// required minor version number
	/// ## `required_subminor`
	/// required sub minor version number
	///
	/// # Returns
	///
	/// True if document version is higher or equal than the given version.
	#[doc(alias = "arv_gc_register_description_node_check_schema_version")]
	pub fn check_schema_version(
		&self,
		required_major: u32,
		required_minor: u32,
		required_subminor: u32,
	) -> bool {
		unsafe {
			from_glib(ffi::arv_gc_register_description_node_check_schema_version(
				self.to_glib_none().0,
				required_major,
				required_minor,
				required_subminor,
			))
		}
	}

	/// Compare the Genicam document version to the given version.
	/// ## `major`
	/// major version number
	/// ## `minor`
	/// minor version number
	/// ## `subminor`
	/// sub minor version number
	///
	/// # Returns
	///
	/// -1 if document version is lower than the given version, 0 if equal and 1 if greater.
	#[doc(alias = "arv_gc_register_description_node_compare_schema_version")]
	pub fn compare_schema_version(&self, major: u32, minor: u32, subminor: u32) -> i32 {
		unsafe {
			ffi::arv_gc_register_description_node_compare_schema_version(
				self.to_glib_none().0,
				major,
				minor,
				subminor,
			)
		}
	}

	/// Gets Genicam document major version.
	///
	/// # Returns
	///
	/// Major version.
	#[doc(alias = "arv_gc_register_description_node_get_major_version")]
	#[doc(alias = "get_major_version")]
	pub fn major_version(&self) -> u32 {
		unsafe { ffi::arv_gc_register_description_node_get_major_version(self.to_glib_none().0) }
	}

	/// Gets Genicam document minor version.
	///
	/// # Returns
	///
	/// Minor version.
	#[doc(alias = "arv_gc_register_description_node_get_minor_version")]
	#[doc(alias = "get_minor_version")]
	pub fn minor_version(&self) -> u32 {
		unsafe { ffi::arv_gc_register_description_node_get_minor_version(self.to_glib_none().0) }
	}

	/// Gets camera model name for given Genicam document.
	///
	/// # Returns
	///
	/// Model name string.
	#[doc(alias = "arv_gc_register_description_node_get_model_name")]
	#[doc(alias = "get_model_name")]
	pub fn model_name(&self) -> Option<glib::GString> {
		unsafe {
			from_glib_full(ffi::arv_gc_register_description_node_get_model_name(
				self.to_glib_none().0,
			))
		}
	}

	/// Gets Genicam document schema major version.
	///
	/// # Returns
	///
	/// Schema major version.
	#[doc(alias = "arv_gc_register_description_node_get_schema_major_version")]
	#[doc(alias = "get_schema_major_version")]
	pub fn schema_major_version(&self) -> u32 {
		unsafe {
			ffi::arv_gc_register_description_node_get_schema_major_version(self.to_glib_none().0)
		}
	}

	/// Gets Genicam document schema minor version.
	///
	/// # Returns
	///
	/// Schema minor version.
	#[doc(alias = "arv_gc_register_description_node_get_schema_minor_version")]
	#[doc(alias = "get_schema_minor_version")]
	pub fn schema_minor_version(&self) -> u32 {
		unsafe {
			ffi::arv_gc_register_description_node_get_schema_minor_version(self.to_glib_none().0)
		}
	}

	/// Gets Genicam document schema sub minor version.
	///
	/// # Returns
	///
	/// Schema sub minor version.
	#[doc(alias = "arv_gc_register_description_node_get_schema_subminor_version")]
	#[doc(alias = "get_schema_subminor_version")]
	pub fn schema_subminor_version(&self) -> u32 {
		unsafe {
			ffi::arv_gc_register_description_node_get_schema_subminor_version(self.to_glib_none().0)
		}
	}

	/// Gets Genicam document sub minor version.
	///
	/// # Returns
	///
	/// Sub minor version.
	#[doc(alias = "arv_gc_register_description_node_get_subminor_version")]
	#[doc(alias = "get_subminor_version")]
	pub fn subminor_version(&self) -> u32 {
		unsafe { ffi::arv_gc_register_description_node_get_subminor_version(self.to_glib_none().0) }
	}

	/// Gets camera vendor name for given Genicam document.
	///
	/// # Returns
	///
	/// Vendor name string.
	#[doc(alias = "arv_gc_register_description_node_get_vendor_name")]
	#[doc(alias = "get_vendor_name")]
	pub fn vendor_name(&self) -> Option<glib::GString> {
		unsafe {
			from_glib_full(ffi::arv_gc_register_description_node_get_vendor_name(
				self.to_glib_none().0,
			))
		}
	}
}

impl Default for GcRegisterDescriptionNode {
	fn default() -> Self {
		Self::new()
	}
}

unsafe impl Send for GcRegisterDescriptionNode {}

impl fmt::Display for GcRegisterDescriptionNode {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("GcRegisterDescriptionNode")
	}
}
