// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::DomElement;
use crate::DomNode;
use crate::GcFeatureNode;
use crate::GcInteger;
use crate::GcNode;
use crate::GcSelector;
use crate::GcString;
use glib::object::Cast;
use glib::translate::*;
use std::fmt;
use std::mem;
use std::ptr;

glib::wrapper! {
	#[doc(alias = "ArvGcEnumeration")]
	pub struct GcEnumeration(Object<ffi::ArvGcEnumeration, ffi::ArvGcEnumerationClass>) @extends GcFeatureNode, GcNode, DomElement, DomNode, @implements GcInteger, GcSelector, GcString;

	match fn {
		type_ => || ffi::arv_gc_enumeration_get_type(),
	}
}

impl GcEnumeration {
	#[doc(alias = "arv_gc_enumeration_new")]
	pub fn new() -> GcEnumeration {
		assert_initialized_main_thread!();
		unsafe { GcNode::from_glib_full(ffi::arv_gc_enumeration_new()).unsafe_cast() }
	}

	/// Create an array of display names of all available entries.
	///
	/// # Returns
	///
	/// an newly created array of const strings, which must freed after use using g_free,
	/// [`None`] on error.
	#[doc(alias = "arv_gc_enumeration_dup_available_display_names")]
	pub fn dup_available_display_names(&self) -> Result<Vec<glib::GString>, glib::Error> {
		unsafe {
			let mut n_values = mem::MaybeUninit::uninit();
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gc_enumeration_dup_available_display_names(
				self.to_glib_none().0,
				n_values.as_mut_ptr(),
				&mut error,
			);
			if error.is_null() {
				Ok(FromGlibContainer::from_glib_container_num(
					ret,
					n_values.assume_init() as usize,
				))
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	///
	/// # Returns
	///
	/// a newly allocated array of 64 bit integers, to be freed after use using `g_free()`.
	#[doc(alias = "arv_gc_enumeration_dup_available_int_values")]
	pub fn dup_available_int_values(&self) -> Result<Vec<i64>, glib::Error> {
		unsafe {
			let mut n_values = mem::MaybeUninit::uninit();
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gc_enumeration_dup_available_int_values(
				self.to_glib_none().0,
				n_values.as_mut_ptr(),
				&mut error,
			);
			if error.is_null() {
				Ok(FromGlibContainer::from_glib_full_num(
					ret,
					n_values.assume_init() as usize,
				))
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	/// Create an array of all available values of `self`, as strings.
	///
	/// # Returns
	///
	/// an newly created array of const strings, which must freed after use using g_free,
	/// [`None`] on error.
	#[doc(alias = "arv_gc_enumeration_dup_available_string_values")]
	pub fn dup_available_string_values(&self) -> Result<Vec<glib::GString>, glib::Error> {
		unsafe {
			let mut n_values = mem::MaybeUninit::uninit();
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gc_enumeration_dup_available_string_values(
				self.to_glib_none().0,
				n_values.as_mut_ptr(),
				&mut error,
			);
			if error.is_null() {
				Ok(FromGlibContainer::from_glib_container_num(
					ret,
					n_values.assume_init() as usize,
				))
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	///
	/// # Returns
	///
	/// the list of enumeration entry nodes.
	#[doc(alias = "arv_gc_enumeration_get_entries")]
	#[doc(alias = "get_entries")]
	pub fn entries(&self) -> Vec<GcFeatureNode> {
		unsafe {
			FromGlibPtrContainer::from_glib_none(ffi::arv_gc_enumeration_get_entries(
				self.to_glib_none().0,
			))
		}
	}

	#[doc(alias = "arv_gc_enumeration_get_int_value")]
	#[doc(alias = "get_int_value")]
	pub fn int_value(&self) -> Result<i64, glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gc_enumeration_get_int_value(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(ret)
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	#[doc(alias = "arv_gc_enumeration_get_string_value")]
	#[doc(alias = "get_string_value")]
	pub fn string_value(&self) -> Result<glib::GString, glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let ret = ffi::arv_gc_enumeration_get_string_value(self.to_glib_none().0, &mut error);
			if error.is_null() {
				Ok(from_glib_none(ret))
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	#[doc(alias = "arv_gc_enumeration_set_int_value")]
	pub fn set_int_value(&self, value: i64) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ = ffi::arv_gc_enumeration_set_int_value(self.to_glib_none().0, value, &mut error);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}

	#[doc(alias = "arv_gc_enumeration_set_string_value")]
	pub fn set_string_value(&self, value: &str) -> Result<(), glib::Error> {
		unsafe {
			let mut error = ptr::null_mut();
			let _ = ffi::arv_gc_enumeration_set_string_value(
				self.to_glib_none().0,
				value.to_glib_none().0,
				&mut error,
			);
			if error.is_null() {
				Ok(())
			} else {
				Err(from_glib_full(error))
			}
		}
	}
}

impl Default for GcEnumeration {
	fn default() -> Self {
		Self::new()
	}
}

unsafe impl Send for GcEnumeration {}

impl fmt::Display for GcEnumeration {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("GcEnumeration")
	}
}
