// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::Buffer;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::mem;

glib::wrapper! {
	#[doc(alias = "ArvFakeCamera")]
	pub struct FakeCamera(Object<ffi::ArvFakeCamera, ffi::ArvFakeCameraClass>);

	match fn {
		type_ => || ffi::arv_fake_camera_get_type(),
	}
}

impl FakeCamera {
	#[doc(alias = "arv_fake_camera_new")]
	pub fn new(serial_number: &str) -> FakeCamera {
		assert_initialized_main_thread!();
		unsafe { from_glib_full(ffi::arv_fake_camera_new(serial_number.to_glib_none().0)) }
	}

	#[doc(alias = "arv_fake_camera_new_full")]
	pub fn new_full(serial_number: &str, genicam_filename: &str) -> FakeCamera {
		assert_initialized_main_thread!();
		unsafe {
			from_glib_full(ffi::arv_fake_camera_new_full(
				serial_number.to_glib_none().0,
				genicam_filename.to_glib_none().0,
			))
		}
	}

	/// Fill a buffer with data from the fake camera.
	/// ## `buffer`
	/// the [`Buffer`][crate::Buffer] to fill
	///
	/// # Returns
	///
	///
	/// ## `packet_size`
	/// the packet size
	#[doc(alias = "arv_fake_camera_fill_buffer")]
	pub fn fill_buffer(&self, buffer: &Buffer) -> u32 {
		unsafe {
			let mut packet_size = mem::MaybeUninit::uninit();
			ffi::arv_fake_camera_fill_buffer(
				self.to_glib_none().0,
				buffer.to_glib_none().0,
				packet_size.as_mut_ptr(),
			);
			let packet_size = packet_size.assume_init();
			packet_size
		}
	}

	#[doc(alias = "arv_fake_camera_get_acquisition_status")]
	#[doc(alias = "get_acquisition_status")]
	pub fn acquisition_status(&self) -> u32 {
		unsafe { ffi::arv_fake_camera_get_acquisition_status(self.to_glib_none().0) }
	}

	#[doc(alias = "arv_fake_camera_get_control_channel_privilege")]
	#[doc(alias = "get_control_channel_privilege")]
	pub fn control_channel_privilege(&self) -> u32 {
		unsafe { ffi::arv_fake_camera_get_control_channel_privilege(self.to_glib_none().0) }
	}

	///
	/// # Returns
	///
	/// the genicam XML description of the camera
	///
	/// ## `size`
	/// the size of the returned XML string
	#[doc(alias = "arv_fake_camera_get_genicam_xml")]
	#[doc(alias = "get_genicam_xml")]
	pub fn genicam_xml(&self) -> (glib::GString, usize) {
		unsafe {
			let mut size = mem::MaybeUninit::uninit();
			let ret = from_glib_none(ffi::arv_fake_camera_get_genicam_xml(
				self.to_glib_none().0,
				size.as_mut_ptr(),
			));
			let size = size.assume_init();
			(ret, size)
		}
	}

	#[doc(alias = "arv_fake_camera_get_heartbeat_timeout")]
	#[doc(alias = "get_heartbeat_timeout")]
	pub fn heartbeat_timeout(&self) -> u32 {
		unsafe { ffi::arv_fake_camera_get_heartbeat_timeout(self.to_glib_none().0) }
	}

	#[doc(alias = "arv_fake_camera_get_payload")]
	#[doc(alias = "get_payload")]
	pub fn payload(&self) -> usize {
		unsafe { ffi::arv_fake_camera_get_payload(self.to_glib_none().0) }
	}

	///
	/// # Returns
	///
	/// the sleep time for the next frame
	///
	/// ## `next_timestamp_us`
	/// the timestamp for the next frame in microseconds
	#[doc(alias = "arv_fake_camera_get_sleep_time_for_next_frame")]
	#[doc(alias = "get_sleep_time_for_next_frame")]
	pub fn sleep_time_for_next_frame(&self) -> (u64, u64) {
		unsafe {
			let mut next_timestamp_us = mem::MaybeUninit::uninit();
			let ret = ffi::arv_fake_camera_get_sleep_time_for_next_frame(
				self.to_glib_none().0,
				next_timestamp_us.as_mut_ptr(),
			);
			let next_timestamp_us = next_timestamp_us.assume_init();
			(ret, next_timestamp_us)
		}
	}

	///
	/// # Returns
	///
	/// the data stream [`gio::SocketAddress`][crate::gio::SocketAddress] for this camera
	#[doc(alias = "arv_fake_camera_get_stream_address")]
	#[doc(alias = "get_stream_address")]
	pub fn stream_address(&self) -> Option<gio::SocketAddress> {
		unsafe {
			from_glib_full(ffi::arv_fake_camera_get_stream_address(
				self.to_glib_none().0,
			))
		}
	}

	//#[doc(alias = "arv_fake_camera_read_memory")]
	//pub fn read_memory(&self, address: u32, size: u32, buffer: /*Unimplemented*/Option<Fundamental: Pointer>) -> bool {
	//    unsafe { TODO: call ffi:arv_fake_camera_read_memory() }
	//}

	/// ## `address`
	/// the register address
	///
	/// # Returns
	///
	/// true if the read succeeded, false otherwise
	///
	/// ## `value`
	/// the register value
	#[doc(alias = "arv_fake_camera_read_register")]
	pub fn read_register(&self, address: u32) -> Option<u32> {
		unsafe {
			let mut value = mem::MaybeUninit::uninit();
			let ret = from_glib(ffi::arv_fake_camera_read_register(
				self.to_glib_none().0,
				address,
				value.as_mut_ptr(),
			));
			let value = value.assume_init();
			if ret {
				Some(value)
			} else {
				None
			}
		}
	}

	#[doc(alias = "arv_fake_camera_set_control_channel_privilege")]
	pub fn set_control_channel_privilege(&self, privilege: u32) {
		unsafe {
			ffi::arv_fake_camera_set_control_channel_privilege(self.to_glib_none().0, privilege);
		}
	}

	#[doc(alias = "arv_fake_camera_set_inet_address")]
	pub fn set_inet_address<P: IsA<gio::InetAddress>>(&self, address: &P) {
		unsafe {
			ffi::arv_fake_camera_set_inet_address(
				self.to_glib_none().0,
				address.as_ref().to_glib_none().0,
			);
		}
	}

	#[doc(alias = "arv_fake_camera_set_trigger_frequency")]
	pub fn set_trigger_frequency(&self, frequency: f64) {
		unsafe {
			ffi::arv_fake_camera_set_trigger_frequency(self.to_glib_none().0, frequency);
		}
	}

	#[doc(alias = "arv_fake_camera_wait_for_next_frame")]
	pub fn wait_for_next_frame(&self) {
		unsafe {
			ffi::arv_fake_camera_wait_for_next_frame(self.to_glib_none().0);
		}
	}

	//#[doc(alias = "arv_fake_camera_write_memory")]
	//pub fn write_memory(&self, address: u32, size: u32, buffer: /*Unimplemented*/Option<Fundamental: Pointer>) -> bool {
	//    unsafe { TODO: call ffi:arv_fake_camera_write_memory() }
	//}

	#[doc(alias = "arv_fake_camera_write_register")]
	pub fn write_register(&self, address: u32, value: u32) -> bool {
		unsafe {
			from_glib(ffi::arv_fake_camera_write_register(
				self.to_glib_none().0,
				address,
				value,
			))
		}
	}
}

unsafe impl Send for FakeCamera {}

impl fmt::Display for FakeCamera {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("FakeCamera")
	}
}
