// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::BufferPayloadType;
use crate::BufferStatus;
use crate::PixelFormat;
use glib::translate::*;
use std::fmt;
use std::mem;

glib::wrapper! {
	#[doc(alias = "ArvBuffer")]
	pub struct Buffer(Object<ffi::ArvBuffer, ffi::ArvBufferClass>);

	match fn {
		type_ => || ffi::arv_buffer_get_type(),
	}
}

impl Buffer {
	//#[doc(alias = "arv_buffer_new")]
	//pub fn new(size: usize, preallocated: /*Unimplemented*/Option<Fundamental: Pointer>) -> Buffer {
	//    unsafe { TODO: call ffi:arv_buffer_new() }
	//}

	/// Creates a new buffer for the storage of the video stream images.
	/// The data space is allocated by this function, and will
	/// be freed when the buffer is destroyed.
	/// ## `size`
	/// payload size
	///
	/// # Returns
	///
	/// a new [`Buffer`][crate::Buffer] object
	#[doc(alias = "arv_buffer_new_allocate")]
	pub fn new_allocate(size: usize) -> Buffer {
		assert_initialized_main_thread!();
		unsafe { from_glib_full(ffi::arv_buffer_new_allocate(size)) }
	}

	/// Chunk data accessor.
	/// ## `chunk_id`
	/// chunk id
	///
	/// # Returns
	///
	/// a pointer to the chunk data.
	#[doc(alias = "arv_buffer_get_chunk_data")]
	#[doc(alias = "get_chunk_data")]
	pub fn chunk_data(&self, chunk_id: u64) -> Vec<u8> {
		unsafe {
			let mut size = mem::MaybeUninit::uninit();
			let ret = FromGlibContainer::from_glib_none_num(
				ffi::arv_buffer_get_chunk_data(self.to_glib_none().0, chunk_id, size.as_mut_ptr()),
				size.assume_init() as usize,
			);
			ret
		}
	}

	/// Gets the buffer frame id. For GigEVision devices, 0 is an invalid value.
	///
	/// # Returns
	///
	/// frame id, 0 on error.
	#[doc(alias = "arv_buffer_get_frame_id")]
	#[doc(alias = "get_frame_id")]
	pub fn frame_id(&self) -> u64 {
		unsafe { ffi::arv_buffer_get_frame_id(self.to_glib_none().0) }
	}

	/// Gets the image width. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	/// image height, in pixels.
	#[doc(alias = "arv_buffer_get_image_height")]
	#[doc(alias = "get_image_height")]
	pub fn image_height(&self) -> i32 {
		unsafe { ffi::arv_buffer_get_image_height(self.to_glib_none().0) }
	}

	/// Gets the image pixel format. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	/// image pixel format.
	#[doc(alias = "arv_buffer_get_image_pixel_format")]
	#[doc(alias = "get_image_pixel_format")]
	pub fn image_pixel_format(&self) -> PixelFormat {
		unsafe {
			from_glib(ffi::arv_buffer_get_image_pixel_format(
				self.to_glib_none().0,
			))
		}
	}

	/// Gets the image region. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	///
	/// ## `x`
	/// image x offset placeholder
	///
	/// ## `y`
	/// image y offset placeholder
	///
	/// ## `width`
	/// image width placholder
	///
	/// ## `height`
	/// image height placeholder
	#[doc(alias = "arv_buffer_get_image_region")]
	#[doc(alias = "get_image_region")]
	pub fn image_region(&self) -> (i32, i32, i32, i32) {
		unsafe {
			let mut x = mem::MaybeUninit::uninit();
			let mut y = mem::MaybeUninit::uninit();
			let mut width = mem::MaybeUninit::uninit();
			let mut height = mem::MaybeUninit::uninit();
			ffi::arv_buffer_get_image_region(
				self.to_glib_none().0,
				x.as_mut_ptr(),
				y.as_mut_ptr(),
				width.as_mut_ptr(),
				height.as_mut_ptr(),
			);
			let x = x.assume_init();
			let y = y.assume_init();
			let width = width.assume_init();
			let height = height.assume_init();
			(x, y, width, height)
		}
	}

	/// Gets the image width. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	/// image width, in pixels.
	#[doc(alias = "arv_buffer_get_image_width")]
	#[doc(alias = "get_image_width")]
	pub fn image_width(&self) -> i32 {
		unsafe { ffi::arv_buffer_get_image_width(self.to_glib_none().0) }
	}

	/// Gets the image x offset. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	/// image x offset, in pixels.
	#[doc(alias = "arv_buffer_get_image_x")]
	#[doc(alias = "get_image_x")]
	pub fn image_x(&self) -> i32 {
		unsafe { ffi::arv_buffer_get_image_x(self.to_glib_none().0) }
	}

	/// Gets the image y offset. This function must only be called on buffer containing a [`BufferPayloadType::Image`][crate::BufferPayloadType::Image] payload.
	///
	/// # Returns
	///
	/// image y offset, in pixels.
	#[doc(alias = "arv_buffer_get_image_y")]
	#[doc(alias = "get_image_y")]
	pub fn image_y(&self) -> i32 {
		unsafe { ffi::arv_buffer_get_image_y(self.to_glib_none().0) }
	}

	/// Gets the buffer payload type.
	///
	/// # Returns
	///
	/// payload type.
	#[doc(alias = "arv_buffer_get_payload_type")]
	#[doc(alias = "get_payload_type")]
	pub fn payload_type(&self) -> BufferPayloadType {
		unsafe { from_glib(ffi::arv_buffer_get_payload_type(self.to_glib_none().0)) }
	}

	/// Gets the buffer acquisition status.
	///
	/// # Returns
	///
	/// buffer acquisition status.
	#[doc(alias = "arv_buffer_get_status")]
	#[doc(alias = "get_status")]
	pub fn status(&self) -> BufferStatus {
		unsafe { from_glib(ffi::arv_buffer_get_status(self.to_glib_none().0)) }
	}

	/// Gets the system timestamp for when the frame was received. Expressed in
	/// nanoseconds.
	///
	/// # Returns
	///
	/// buffer system timestamp, in nanoseconds.
	#[doc(alias = "arv_buffer_get_system_timestamp")]
	#[doc(alias = "get_system_timestamp")]
	pub fn system_timestamp(&self) -> u64 {
		unsafe { ffi::arv_buffer_get_system_timestamp(self.to_glib_none().0) }
	}

	/// Gets the buffer camera timestamp, expressed as nanoseconds. Not all devices
	/// provide reliable timestamp, which means sometimes its better to rely on the
	/// buffer completion host local time, or to use
	/// [`system_timestamp()`][Self::system_timestamp()].
	///
	/// # Returns
	///
	/// buffer timestamp, in nanoseconds.
	#[doc(alias = "arv_buffer_get_timestamp")]
	#[doc(alias = "get_timestamp")]
	pub fn timestamp(&self) -> u64 {
		unsafe { ffi::arv_buffer_get_timestamp(self.to_glib_none().0) }
	}

	//#[doc(alias = "arv_buffer_get_user_data")]
	//#[doc(alias = "get_user_data")]
	//pub fn user_data(&self) -> /*Unimplemented*/Option<Fundamental: Pointer> {
	//    unsafe { TODO: call ffi:arv_buffer_get_user_data() }
	//}

	///
	/// # Returns
	///
	/// [`true`] if `self` has a payload type that contains chunk data.
	#[doc(alias = "arv_buffer_has_chunks")]
	pub fn has_chunks(&self) -> bool {
		unsafe { from_glib(ffi::arv_buffer_has_chunks(self.to_glib_none().0)) }
	}

	/// Sets the buffer frame id. For GigEVision devices, 0 is an invalid value.
	/// ## `frame_id`
	/// a `guint64`
	#[cfg(any(feature = "v0_8_3", feature = "dox"))]
	#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_8_3")))]
	#[doc(alias = "arv_buffer_set_frame_id")]
	pub fn set_frame_id(&self, frame_id: u64) {
		unsafe {
			ffi::arv_buffer_set_frame_id(self.to_glib_none().0, frame_id);
		}
	}

	/// Sets the system timestamp for when the frame was received. Expressed in
	/// nanoseconds.
	/// ## `timestamp_ns`
	/// a timestamp, expressed as nanoseconds
	#[doc(alias = "arv_buffer_set_system_timestamp")]
	pub fn set_system_timestamp(&self, timestamp_ns: u64) {
		unsafe {
			ffi::arv_buffer_set_system_timestamp(self.to_glib_none().0, timestamp_ns);
		}
	}

	/// Sets the buffer timestamp, which allows to override the timpestamp set by
	/// the camera, which in some case is incorrect.
	/// ## `timestamp_ns`
	/// a timestamp, expressed as nanoseconds
	#[doc(alias = "arv_buffer_set_timestamp")]
	pub fn set_timestamp(&self, timestamp_ns: u64) {
		unsafe {
			ffi::arv_buffer_set_timestamp(self.to_glib_none().0, timestamp_ns);
		}
	}
}

unsafe impl Send for Buffer {}

impl fmt::Display for Buffer {
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		f.write_str("Buffer")
	}
}
