use super::*;


/// An `Rc<str>` and possibly a file path.  
#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct Page {

	pub(crate) path_maybe: Option<PathBuf>,
	pub(crate) string: Rc<str>

}

impl Page {

	pub fn path(&self) -> &Option<PathBuf> {

		&self.path_maybe

	}

}


impl From<&str> for Page {

	fn from(string: &str) -> Self {
		
		let string = Rc::from(string);
		let path_maybe = None;

		Self { path_maybe, string }

	}

}

impl Deref for Page {

	type Target = str;

	fn deref(&self) -> &Self::Target {
		
		self.string.deref()

	}

}
