use super::*;

/// The reason for starting an [`Event`].
#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Goal {

	Read(Read),
	Parse(Parse),
	None

}

impl Goal {

	pub fn is_parse(&self) -> bool {

		matches!(self, Goal::Parse(_))

	}

	pub fn is_read(&self) -> bool {

		matches!(self, Goal::Read(_))

	}

	pub fn is_none(&self) -> bool {

		matches!(self, Goal::None)

	}

}