use super::*;

/// The outcome of some [`Event`].
#[derive(Clone, Debug, Hash, PartialEq, Eq, PartialOrd, Ord)]
pub enum Status {

	Success(String),
	Warning(String),
	Error(String),
	Note(String),
	
}

impl Status {

	/// Whether `self` is `Self::Success(_)`.
	pub fn is_success (&self) -> bool {
		
		matches!(self, Self::Success(_))
		
	}
	
	/// Whether `self` is `Self::Warning(_)`.
	pub fn is_warning(&self) -> bool {
		
		matches!(self, Self::Warning(_))
		
	}
	
	/// Whether `self` is `Self::Error(_)`.
	pub fn is_error(&self) -> bool {
		
		matches!(self, Self::Error(_))
		
	}
	
	/// Whether `self` is `Self::Note(_)`.
	pub fn is_note(&self) -> bool {
		
		matches!(self, Self::Note(_))
		
	}

	pub(crate) fn color(&self) -> Color {

		match self {

			Self::Warning(_) => Color::Yellow,
			Self::Error(_) => Color::Red,
			Self::Note(_) => Color::Blue,
			Self::Success(_) => Color::Green,

		}

	}

	pub fn description(&self) -> &str {

		match self {

			Self::Warning(description) => &description,
			Self::Error(description) => &description,
			Self::Note(description) => &description,
			Self::Success(description) => &description,

		}

	} 

}