#![allow(unused_imports)]
#![allow(dead_code)]

use std::ops::Deref;
use std::rc::Rc;
use std::path::PathBuf;
use std::fmt::{ Debug, Display, Formatter };
use std::any::{ TypeId, Any };
use std::ops::Range;
use crossterm::*;
use crossterm::style::*;
use std::ops::Index;
use std::io::stdout;
use std::ops::Add;
use std::collections::hash_map::DefaultHasher;
use std::collections::BTreeSet;
use std::borrow::BorrowMut;
use std::path::Path;
use std::fs::read_to_string;

type Result<T> = std::result::Result<T,()>;

mod place;
mod event;
mod goal;
mod span;
mod page;
mod state;
mod status;

pub use span::*;
pub use place::*;
pub use event::*;
pub use goal::*;
pub use page::*;
pub use state::*;
pub use status::*;

#[cfg(test)]
mod tests {
    
	use crate::*;

	#[test]
	fn display() -> Result<()> {

		let page = Page::from(" \n welp ");

		let mut state = State::from(page);

		state.advance(3)?;
		
		let event = state.start_parse::<usize>();
		
		state.advance(2)?;
		
		let other_event = state.start_parse::<usize>();

		let description = "Something succeeded.".to_string();
		state.finish_event(other_event, Status::Success(description));
		
		state.advance(1)?;
		
		state.finish_event(event, Status::Error("Oh no - something happened.".to_string()));

		for event in state.history() {

			println!("{event}")

		}

		Ok(())
		
	}


}
