use super::*;

#[derive(Clone, Copy, Hash, Debug, PartialEq, Eq, PartialOrd, Ord)]
pub struct Parse {

	pub(crate) type_identifier: TypeId,
	pub(crate) index: usize,
	pub(crate) depth: usize,

}

impl Parse {

	pub fn new<T : 'static>(state: &State) -> Self {

		let type_identifier = TypeId::of::<T>();
		let index = state.index;
		
		let mut depth = 0;
		
		state.history.iter().for_each(|event| {

			if let Goal::Parse(parse) = event.goal {

				let same_type = parse.type_identifier == type_identifier;
				let same_index = parse.index == index;
	
				if same_type && same_index { 
				
					depth += 1;
				 
				}

			}

		});

		Parse { type_identifier, index, depth }

	}

}
