use super::*;

/// A reference to a span of some `&str`.
#[derive(Clone, PartialEq, Eq, Hash)]
pub struct Span {

	pub(crate) start: Boundary,
	pub(crate) end: Boundary,
	pub(crate) string: Rc::<str>,

}

impl Span {

	/// A Boun
	pub fn start(&self) -> Boundary {
		
		self.start
		
	}
	
	pub fn end(&self) -> Boundary {

		self.end

	}

	/// Assigns `self.end`.
	pub fn reassign_end(&mut self, end: usize) {
		
		self.end = Boundary::new(self.string(), end);

	}

	/// A slice of `self.string()`.
	pub fn slice(&self) -> &str {

		&self.string[self.range()]

	}

	/// The complete `&str` referenced by `self`.
	pub fn string(&self) -> &str {
		
		&self.string

	}

	/// The indices of `self.slice()`.
	pub fn range(&self) -> Range<usize> {

		self.start.index .. self.end.index

	}

	/// Constructs a new `Span`.
	pub fn new(string: &str, range: Range<usize>) -> Span {

		let start = Boundary::new(string, range.start);
		let mut end = Boundary::new(string, range.end);
		end.line += 1;

		let string = Rc::from(string);

		Self { string, start, end }
		
	}

}

impl Debug for Span {

	fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
		
		let slice = &self.slice();
		let start = self.start.index;
		let end = self.end.index;
		let line_start = self.start.line;
		let line_end = self.end.line;
		
		write!(f, "[{slice:?}, {start}..{end}, lines {line_start}..{line_end}]")

	}

}

impl Ord for Span {

	fn cmp(&self, other: &Self) -> std::cmp::Ordering {
		
		self.start.index.cmp(&other.start.index)

	}

}

impl PartialOrd for Span {

	fn partial_cmp(&self, other: &Self) -> Option<std::cmp::Ordering> {
		
		self.start.index.partial_cmp(&other.start.index)

	}

}

impl AsRef<str> for Span {

	fn as_ref(&self) -> &str {
	
		self.slice()
		
	}

}

impl Deref for Span {

	type Target = str;

	fn deref(&self) -> &Self::Target {
	
		self.slice()
		
	}

}

