#![allow(dead_code)]


/*!
 * 
 * An error-reporting library for `aqua`.
 *  
 */ 

use std::io::stdout;
use std::ops::*;
use std::fmt::Display;
use crossterm::*;
use crossterm::style::*;
use std::rc::Rc;
use std::fmt::Debug;

mod level;
mod error;
mod span;
mod boundary;

pub use boundary::*;
pub use span::*;
pub use error::*;
pub use level::*;

/// Type alias for `Result<T, aqua_error::Error>`.
pub type Result<T> = std::result::Result<T, Error>;

#[cfg(test)]
mod tests {

	use crate::*;

    #[test]
    fn test() {

		let string = " first asdfasdf \r\n\t second \n third ";
	
		let span = Span::new(string, 1..6);
		let warning = Error::new(Some(span.clone()), Level::Warning, "This is a warning.");
	
		let other_span = Span::new(string, 21..23);
		let mut error = Error::new(Some(other_span.clone()), Level::Error, "Haha nope.");
		
		error += warning;

		println!("{error}")
		
	}

}
