
/// A start or end of a `Span`.
#[derive(Clone, Copy, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct Boundary {

	pub(crate) index: usize,
	pub(crate) line: usize,
	pub(crate) indentation: usize,
	pub(crate) column: usize

}

impl Boundary {

	/// `self.index`
	pub fn index(&self) -> usize {

		self.index

	}

	/// `self.line`
	pub fn line(&self) -> usize {

		self.line

	}

	/// `self.indentation`
	pub fn indentation(&self) -> usize {

		self.indentation

	}

	/// `self.column`
	pub fn column(&self) -> usize {

		self.column

	}

	/// Constructs a new `Boundary`.
	pub fn new(string: &str, index: usize) -> Boundary {

		let mut line = 1;
		let mut column = 1;
		
		for (character_index, character) in string.char_indices() {

			if character_index == index { break; }

			if character == '\n' {

				line += 1;
				column = 1;

			} 
			
			else {
				
				column += 1;

			}

		}

		let mut indentation = 0;

		for (line_number, line_string) in string.lines().into_iter().enumerate() {

			let actual_line_number = line_number + 1;

			if actual_line_number == line {

				for character in line_string.chars() {

					if character == '\t' { indentation += 1; }
					else { break; }

				} 

			}

		}

		Boundary { line, column, indentation, index }
		
	}

}
