#![feature(type_name_of_val)]
#![allow(dead_code)]

//! An error reporting library for `aqua_parse`.

use std::io::stdout;
use std::ops::*;
use crossterm::*;
use crossterm::style::*;
use std::rc::Rc;
use std::path::{ Path, PathBuf };
use std::fmt::{ Debug, Display, Formatter };

mod page;
mod level;
mod error;
mod span;
mod place;

pub use page::*;
pub use place::*;
pub use span::*;
pub use error::*;
pub use level::*;

/// Type alias for `Result<T, aqua_error::Error>`.
pub type Result<T> = std::result::Result<T, Error>;

#[cfg(test)]
mod tests {

	use crate::*;

    #[test]
    fn test() {

		let string = "first asdfasdf \r\n\t second \n third ";
		let page = Page::from(string);
	
		let span = Span::new(Rc::new(page.clone()), 0..5);
		let span_maybe = Some(span.clone());
		let description = "This is a warning.";
		let level = Level::Warning;
		let warning = Error::new(span_maybe, level, description);
	
		let other_span = Span::new(Rc::new(page), 21..23);
		let other_span_maybe = Some(other_span);
		let other_description = "Haha yeah.";
		let other_level = Level::Error;
		let mut error = Error::new(other_span_maybe, other_level, other_description);
	
		error += warning;

		println!("{error}");

		println!("{span:?}")

	}

}
