use super::*;

/// A descriptor of some position in a string.
#[derive(Copy, Clone, Debug, PartialEq, Eq, Hash)]
pub struct Place {

	pub(crate) index: usize,
	pub(crate) line: usize,
	pub(crate) indentation: usize,
	pub(crate) column: usize,
	pub(crate) character: char,

}

impl Place {

	/// `self.index`
	pub fn index(&self) -> usize {

		self.index

	}

	/// `self.line`
	pub fn line(&self) -> usize {

		self.line

	}

	/// `self.character`
	pub fn character(&self) -> char {

		self.character

	}

	/// `self.indentation`
	pub fn indentation(&self) -> usize {

		self.indentation

	}

	/// `self.column`
	pub fn column(&self) -> usize {

		self.column

	}

	/// Constructs a new `Place`.
	pub fn new(page: &Page, index: usize) -> Place {

		let mut line = 1;
		let mut column = 1;
		
		let mut should_advance_line = false;

		let string = page.string.deref();

		let mut character = '?';

		for (character_index, string_character) in string.char_indices() {

			if character_index == index { 
				
				character = string_character;
				break; 
			
			}

			if should_advance_line {

				line += 1;
				column = 1;
				should_advance_line = false;

			}

			if string_character == '\n' { should_advance_line = true; } 
			
			else { column += 1; }

		}

		let mut indentation = 0;

		for (line_number, line_string) in string.lines().into_iter().enumerate() {

			let actual_line_number = line_number + 1;

			if actual_line_number == line {

				for character in line_string.chars() {

					if character == '\t' { indentation += 1; }
					else { break; }

				} 

			}

		}

		Place { character, line, column, indentation, index }
		
	}

}

impl Ord for Place {

	fn cmp(&self, other: &Self) -> std::cmp::Ordering {
		
		self.index.cmp(&other.index)

	}

}

impl PartialOrd for Place {

	fn partial_cmp(&self, other: &Self) -> Option<std::cmp::Ordering> {
		
		Some(self.cmp(&other))

	}

}