use super::*;

/// The severity level of an `Error`.
#[derive(Clone, Copy, Debug, Hash, PartialEq, Eq)]
pub enum Level {

	Warning,
	Error,
	Note,

}

impl Level {

	pub(crate) fn color(&self) -> Color {

		match self {

			Self::Warning => Color::Yellow,
			Self::Error => Color::Red,
			Self::Note => Color::Blue,

		}

	} 

}
