#![allow(dead_code)]

/*!
 * 
 * An error-reporting library for `aqua`.
 *  
 */ 

mod level;
mod error;
mod message;

pub use message::*;
pub use error::*;
pub use level::*;

#[cfg(test)]
mod tests {

	use crate::*;

    #[test]
    fn test() {

		let string = "Dog\n\t aw paw";

		let mut error = Error::from(string);
		
		let mut warning = Message::start(5, Level::Warning, "This is a warning.");
	
		warning.end(8);

		error += warning;

		println!("{}", error);

	}

}
