use std::collections::HashMap;

use apptrail_application_events_sdk::{
    event::{Actor, ApptrailEvent, Context, Resource},
    ApptrailEventsClient,
};
use chrono::prelude::{DateTime, Utc};
use serde_json::json;
use uuid::Uuid;

fn iso8601() -> String {
    let dt: DateTime<Utc> = std::time::SystemTime::now().into();
    format!("{}", dt.format("%Y-%m-%dT%H:%M:%S%.3f%:z"))
}

#[test]
fn it_works() {
    let e1 = ApptrailEvent {
        tenant_id: Uuid::new_v4().to_string(),
        event_name: "CreateFoo".to_string(),
        event_time: iso8601(),
        actor: None,
        context: None,
        event_details: None,
        resources: None,
        tags: None,
    };
    let event = ApptrailEvent {
        tenant_id: "cust_MGY4MmYzNDMtZjEwOC00OWI".to_string(),
        event_name: "CreateFoo".to_string(),
        event_time: iso8601(),
        actor: Some(Actor {
            id: "acct_MmRlODllZDctM2I0Yi0".to_string(),
            details: Some(HashMap::from([
                ("type".to_string(), Some(json!("account"))),
                ("name".to_string(), Some(json!("API Access"))),
            ])),
        }),
        resources: Some(vec![Resource {
            id: "repo_YWI5NjkzY2UtNzI1Ny00N".to_string(),
            details: Some(HashMap::from([(
                "repositoryType".to_string(),
                Some(json!("V2")),
            )])),
        }]),
        context: Some(Context {
            source_ip_address: Some("103.6.179.245".to_string()),
            user_agent: Some("Apache-HttpClient/4.5.3 (Java/11.0.11)".to_string()),
        }),
        event_details: Some(HashMap::from([(
            "request".to_string(),
            Some(json!({
              "repositoryName": "my-repository",
            })),
        )])),
        tags: Some(HashMap::from([("severity".to_string(), "LOW".to_string())])),
    };
    let events = vec![&e1, &event];

    println!("{:#?}", e1);
    let rt = tokio::runtime::Runtime::new().unwrap();
    let mut client: ApptrailEventsClient = ApptrailEventsClient::new(String::from("us-west-2"), String::from("NjA0NzZiOTktMzBmMS00ZjZjLThkZjMtY2FmZWI0ODVkZmZmLGpxSE16cTcsYWQ0OGUwYjMtNjdlZS00MGZmLThkNjgtYTg3YTJiZTBjZmU3")).unwrap();
    rt.block_on(async {
        println!("{}", client);
        client
            .put_events(&events)
            .await
            .map_or_else(|err| println!("FAILED: {}", err), |()| ())
    });
}
