// This file was generated by gir (https://github.com/gtk-rs/gir)
// from /home/rene/git/gir-files
// DO NOT EDIT

use crate::IndicatorCategory;
use crate::IndicatorStatus;
use gdk::cairo::ffi::FORMAT_A_RGB32;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "AppIndicator")]
/// A application indicator type
/// 
///  
/// A application indicator represents the values that are needed to show a
/// unique status in the panel for an application. In general, applications
/// should try to fit in the other indicators that are available on the
/// panel before using this. But, sometimes it is necissary.
/// 
/// # Implements
/// 
/// [`AppIndicatorExt`][trait@crate::prelude::AppIndicatorExt], [`AppIndicatorBuilderExt`][trait@crate::prelude::AppIndicatorBuilderExt]
    pub struct Indicator(Object<ffi::AppIndicator, ffi::AppIndicatorClass>);

    match fn {
        type_ => || ffi::app_indicator_get_type(),
    }
}

impl Indicator {
        pub const NONE: Option<&'static Indicator> = None;
    

    /// Creates a new [`Indicator`][crate::Indicator] setting the properties:
    /// `property::Indicator::id` with `id`, `property::Indicator::category` with `category`
    /// and `property::Indicator::icon-name` with `icon_name`.
    /// ## `id`
    /// The unique id of the indicator to create.
    /// ## `icon_name`
    /// The icon name for this indicator
    /// ## `category`
    /// The category of indicator.
    ///
    /// # Returns
    ///
    /// A pointer to a new [`Indicator`][crate::Indicator] object.
    #[doc(alias = "app_indicator_new")]
    pub fn new(id: &str, icon_name: &str, category: IndicatorCategory) -> Indicator {
        unsafe {
            from_glib_full(ffi::app_indicator_new(id.to_glib_none().0, icon_name.to_glib_none().0, category.into_glib()))
        }
    }

    /// Creates a new [`Indicator`][crate::Indicator] setting the properties:
    /// `property::Indicator::id` with `id`, `property::Indicator::category` with `category`,
    /// `property::Indicator::icon-name` with `icon_name` and `property::Indicator::icon-theme-path`
    /// with `icon_theme_path`.
    /// ## `id`
    /// The unique id of the indicator to create.
    /// ## `icon_name`
    /// The icon name for this indicator
    /// ## `category`
    /// The category of indicator.
    /// ## `icon_theme_path`
    /// A custom path for finding icons.
    ///
    /// # Returns
    ///
    /// A pointer to a new [`Indicator`][crate::Indicator] object.
    #[doc(alias = "app_indicator_new_with_path")]
    #[doc(alias = "new_with_path")]
    pub fn with_path(id: &str, icon_name: &str, category: IndicatorCategory, icon_theme_path: &str) -> Indicator {
        unsafe {
            from_glib_full(ffi::app_indicator_new_with_path(id.to_glib_none().0, icon_name.to_glib_none().0, category.into_glib(), icon_theme_path.to_glib_none().0))
        }
    }
}

/// Trait containing all [`struct@Indicator`] methods.
///
/// # Implementors
///
/// [`Indicator`][struct@crate::Indicator]
pub trait AppIndicatorExt: 'static {
    /// This function allows for building the Application Indicator menu
    /// from a static desktop file.
    /// ## `desktop_file`
    /// A path to the desktop file to build the menu from
    /// ## `desktop_profile`
    /// Which entries should be used from the desktop file
    #[doc(alias = "app_indicator_build_menu_from_desktop")]
    fn build_menu_from_desktop(&self, desktop_file: &str, desktop_profile: &str);

    /// Wrapper function for property `property::Indicator::attention-icon-name`.
    ///
    /// # Returns
    ///
    /// The current attention icon name.
    #[doc(alias = "app_indicator_get_attention_icon")]
    #[doc(alias = "get_attention_icon")]
    fn attention_icon(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::attention-icon-desc`.
    ///
    /// # Returns
    ///
    /// The current attention icon description.
    #[doc(alias = "app_indicator_get_attention_icon_desc")]
    #[doc(alias = "get_attention_icon_desc")]
    fn attention_icon_desc(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::category`.
    ///
    /// # Returns
    ///
    /// The current category.
    #[doc(alias = "app_indicator_get_category")]
    #[doc(alias = "get_category")]
    fn category(&self) -> IndicatorCategory;

    /// Wrapper function for property `property::Indicator::icon-name`.
    ///
    /// # Returns
    ///
    /// The current icon name.
    #[doc(alias = "app_indicator_get_icon")]
    #[doc(alias = "get_icon")]
    fn icon(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::icon-desc`.
    ///
    /// # Returns
    ///
    /// The current icon description.
    #[doc(alias = "app_indicator_get_icon_desc")]
    #[doc(alias = "get_icon_desc")]
    fn icon_desc(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::icon-theme-path`.
    ///
    /// # Returns
    ///
    /// The current icon theme path.
    #[doc(alias = "app_indicator_get_icon_theme_path")]
    #[doc(alias = "get_icon_theme_path")]
    fn icon_theme_path(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::id`.
    ///
    /// # Returns
    ///
    /// The current ID
    #[doc(alias = "app_indicator_get_id")]
    #[doc(alias = "get_id")]
    fn id(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::label`.
    ///
    /// # Returns
    ///
    /// The current label.
    #[doc(alias = "app_indicator_get_label")]
    #[doc(alias = "get_label")]
    fn label(&self) -> Option<glib::GString>;

    /// Wrapper function for property `property::Indicator::label-guide`.
    ///
    /// # Returns
    ///
    /// The current label guide.
    #[doc(alias = "app_indicator_get_label_guide")]
    #[doc(alias = "get_label_guide")]
    fn label_guide(&self) -> Option<glib::GString>;

    /// Gets the menu being used for this application indicator.
    /// Wrapper function for property `property::Indicator::menu`.
    ///
    /// # Returns
    ///
    /// A [`gtk::Menu`][crate::gtk::Menu] object or [`None`] if one hasn't been set.
    #[doc(alias = "app_indicator_get_menu")]
    #[doc(alias = "get_menu")]
    fn menu(&self) -> Option<gtk::Menu>;

    /// Wrapper function for property `property::Indicator::ordering-index`.
    ///
    /// # Returns
    ///
    /// The current ordering index.
    #[doc(alias = "app_indicator_get_ordering_index")]
    #[doc(alias = "get_ordering_index")]
    fn ordering_index(&self) -> u32;

    /// Gets the menuitem being called on secondary-activate event.
    ///
    /// # Returns
    ///
    /// A [`gtk::Widget`][crate::gtk::Widget] object or [`None`] if none has been set.
    #[doc(alias = "app_indicator_get_secondary_activate_target")]
    #[doc(alias = "get_secondary_activate_target")]
    fn secondary_activate_target(&self) -> Option<gtk::Widget>;

    /// Wrapper function for property `property::Indicator::status`.
    ///
    /// # Returns
    ///
    /// The current status.
    #[doc(alias = "app_indicator_get_status")]
    #[doc(alias = "get_status")]
    fn status(&self) -> IndicatorStatus;

    /// Gets the title of the application indicator. See the function
    /// [`set_title()`][Self::set_title()] for information on the title.
    ///
    /// # Returns
    ///
    /// The current title.
    #[cfg(any(feature = "v0_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_5")))]
    #[doc(alias = "app_indicator_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    /// Wrapper for [`set_attention_icon_full()`][Self::set_attention_icon_full()] with a NULL
    /// description.
    ///
    /// # Deprecated
    ///
    /// Use [`set_attention_icon_full()`][Self::set_attention_icon_full()] instead.
    /// ## `icon_name`
    /// The name of the attention icon to set for this indicator
    #[doc(alias = "app_indicator_set_attention_icon")]
    fn set_attention_icon(&self, icon_name: &str);

    /// Wrapper function for property `property::Indicator::attention-icon-name`.
    /// ## `icon_name`
    /// The name of the attention icon to set for this indicator
    /// ## `icon_desc`
    /// A textual description of the icon
    #[doc(alias = "app_indicator_set_attention_icon_full")]
    fn set_attention_icon_full(&self, icon_name: &str, icon_desc: &str);

    /// Wrapper function for [`set_icon_full()`][Self::set_icon_full()] with a NULL
    /// description.
    ///
    /// # Deprecated
    ///
    /// Use [`set_icon_full()`][Self::set_icon_full()]
    /// ## `icon_name`
    /// The icon name to set.
    #[doc(alias = "app_indicator_set_icon")]
    fn set_icon(&self, icon_name: &str);

    /// Sets the default icon to use when the status is active but
    /// not set to attention. In most cases, this should be the
    /// application icon for the program.
    ///
    /// Wrapper function for property `property::Indicator::icon-name` and
    /// `signal::Indicator::icon-desc`.
    /// ## `icon_name`
    /// The icon name to set.
    /// ## `icon_desc`
    /// A textual description of the icon for accessibility
    #[doc(alias = "app_indicator_set_icon_full")]
    fn set_icon_full(&self, icon_name: &str, icon_desc: &str);

    /// Sets the path to use when searching for icons.
    /// ## `icon_theme_path`
    /// The icon theme path to set.
    #[doc(alias = "app_indicator_set_icon_theme_path")]
    fn set_icon_theme_path(&self, icon_theme_path: &str);

    /// This is a wrapper function for the `property::Indicator::label` and
    /// `property::Indicator::guide` properties. This function can take [`None`]
    /// as either `label` or `guide` and will clear the entries.
    /// ## `label`
    /// The label to show next to the icon.
    /// ## `guide`
    /// A guide to size the label correctly.
    #[doc(alias = "app_indicator_set_label")]
    fn set_label(&self, label: &str, guide: &str);

    /// Sets the menu that should be shown when the Application Indicator
    /// is clicked on in the panel. An application indicator will not
    /// be rendered unless it has a menu.
    ///
    /// Wrapper function for property `property::Indicator::menu`.
    /// ## `menu`
    /// A [`gtk::Menu`][crate::gtk::Menu] to set
    #[doc(alias = "app_indicator_set_menu")]
    fn set_menu(&self, menu: Option<&impl IsA<gtk::Menu>>);

    /// Sets the ordering index for the app indicator which effects the
    /// placement of it on the panel. For almost all app indicator
    /// this is not the function you're looking for.
    ///
    /// Wrapper function for property `property::Indicator::ordering-index`.
    /// ## `ordering_index`
    /// A value for the ordering of this app indicator
    #[doc(alias = "app_indicator_set_ordering_index")]
    fn set_ordering_index(&self, ordering_index: u32);

    /// Set the `menuitem` to be activated when a secondary activation event (i.e. a
    /// middle-click) is emitted over the [`Indicator`][crate::Indicator] icon/label.
    ///
    /// The `menuitem` can be also a complex [`gtk::Widget`][crate::gtk::Widget], but to get activated when
    /// a secondary activation occurs in the `Appindicator`, it must be a visible and
    /// active child (or inner-child) of the `property::Indicator::menu`.
    ///
    /// Setting `menuitem` to [`None`] causes to disable this feature.
    /// ## `menuitem`
    /// A [`gtk::Widget`][crate::gtk::Widget] to be activated on secondary activation
    #[doc(alias = "app_indicator_set_secondary_activate_target")]
    fn set_secondary_activate_target(&self, menuitem: Option<&impl IsA<gtk::Widget>>);

    /// Wrapper function for property `property::Indicator::status`.
    /// ## `status`
    /// The status to set for this indicator
    #[doc(alias = "app_indicator_set_status")]
    fn set_status(&self, status: IndicatorStatus);

    /// Sets the title of the application indicator, or how it should be referred
    /// in a human readable form. This string should be UTF-8 and localized as it
    /// expected that users will set it.
    ///
    /// In the Unity desktop the most prominent place that this is show will be
    /// in the HUD. HUD listings for this application indicator will start with
    /// the title as the first part of the line for the menu items.
    ///
    /// Setting `title` to [`None`] removes the title.
    /// ## `title`
    /// Title of the app indicator
    #[cfg(any(feature = "v0_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_5")))]
    #[doc(alias = "app_indicator_set_title")]
    fn set_title(&self, title: Option<&str>);

    /// If the indicator sets it's status to [`IndicatorStatus::Attention`][crate::IndicatorStatus::Attention]
    /// then this textual description of the icon shown.
    #[doc(alias = "attention-icon-desc")]
    fn set_attention_icon_desc(&self, attention_icon_desc: Option<&str>);

    /// If the indicator sets it's status to [`IndicatorStatus::Attention`][crate::IndicatorStatus::Attention]
    /// then this icon is shown.
    #[doc(alias = "attention-icon-name")]
    fn attention_icon_name(&self) -> Option<glib::GString>;

    /// If the indicator sets it's status to [`IndicatorStatus::Attention`][crate::IndicatorStatus::Attention]
    /// then this icon is shown.
    #[doc(alias = "attention-icon-name")]
    fn set_attention_icon_name(&self, attention_icon_name: Option<&str>);

    /// Pretty simple, [`true`] if we have a reasonable expectation of being
    /// displayed through this object. You should hide your TrayIcon if so.
    fn is_connected(&self) -> bool;

    /// The description of the regular icon that is shown for the indicator.
    #[doc(alias = "icon-desc")]
    fn set_icon_desc(&self, icon_desc: Option<&str>);

    /// The name of the regular icon that is shown for the indicator.
    #[doc(alias = "icon-name")]
    fn icon_name(&self) -> Option<glib::GString>;

    /// The name of the regular icon that is shown for the indicator.
    #[doc(alias = "icon-name")]
    fn set_icon_name(&self, icon_name: Option<&str>);

    /// An optional string to provide guidance to the panel on how big
    /// the `property::Indicator::label` string could get. If this is set correctly
    /// then the panel should never 'jiggle' as the string adjusts through
    /// out the range of options. For instance, if you were providing a
    /// percentage like "54% thrust" in `property::Indicator::label` you'd want to
    /// set this string to "100% thrust" to ensure space when Scotty can
    /// get you enough power.
    #[doc(alias = "label-guide")]
    fn set_label_guide(&self, label_guide: Option<&str>);

    /// Provides a way to refer to this application indicator in a human
    /// readable form. This is used in the Unity desktop in the HUD as
    /// the first part of the menu entries to distinguish them from the
    /// focused application's entries.
    fn get_property_title(&self) -> Option<glib::GString>;

    /// Provides a way to refer to this application indicator in a human
    /// readable form. This is used in the Unity desktop in the HUD as
    /// the first part of the menu entries to distinguish them from the
    /// focused application's entries.
    fn set_property_title(&self, title: Option<&str>);

    /// Signaled when we connect to a watcher, or when it drops away.
    /// ## `arg1`
    /// Whether we're connected or not
    #[doc(alias = "connection-changed")]
    fn connect_connection_changed<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    /// Emitted when `property::Indicator::attention-icon-name` is changed
    #[doc(alias = "new-attention-icon")]
    fn connect_new_attention_icon<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    /// when `property::Indicator::icon-name` is changed
    #[doc(alias = "new-icon")]
    fn connect_new_icon<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    /// Signaled when there is a new icon set for the
    /// object.
    #[doc(alias = "new-icon-theme-path")]
    fn connect_new_icon_theme_path<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    /// Emitted when either `property::Indicator::label` or `property::Indicator::label-guide` are
    /// changed.
    #[doc(alias = "new-label")]
    fn connect_new_label<F: Fn(&Self, &str, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    /// Emitted when `property::Indicator::status` is changed
    /// ## `arg1`
    /// The string value of the [`IndicatorStatus`][crate::IndicatorStatus] enum.
    #[doc(alias = "new-status")]
    fn connect_new_status<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    /// Signaled when the [`Indicator`][crate::Indicator] receives a scroll event.
    /// ## `arg1`
    /// How many steps the scroll wheel has taken
    /// ## `arg2`
    /// Which direction the wheel went in
    #[doc(alias = "scroll-event")]
    fn connect_scroll_event<F: Fn(&Self, i32, gdk::ScrollDirection) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "attention-icon-desc")]
    fn connect_attention_icon_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "attention-icon-name")]
    fn connect_attention_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "connected")]
    fn connect_connected_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-desc")]
    fn connect_icon_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-theme-path")]
    fn connect_icon_theme_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "label")]
    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "label-guide")]
    fn connect_label_guide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ordering-index")]
    fn connect_ordering_index_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "status")]
    fn connect_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Indicator>> AppIndicatorExt for O {
    fn build_menu_from_desktop(&self, desktop_file: &str, desktop_profile: &str) {
        unsafe {
            ffi::app_indicator_build_menu_from_desktop(self.as_ref().to_glib_none().0, desktop_file.to_glib_none().0, desktop_profile.to_glib_none().0);
        }
    }

    fn attention_icon(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_attention_icon(self.as_ref().to_glib_none().0))
        }
    }

    fn attention_icon_desc(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_attention_icon_desc(self.as_ref().to_glib_none().0))
        }
    }

    fn category(&self) -> IndicatorCategory {
        unsafe {
            from_glib(ffi::app_indicator_get_category(self.as_ref().to_glib_none().0))
        }
    }

    fn icon(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_icon(self.as_ref().to_glib_none().0))
        }
    }

    fn icon_desc(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_icon_desc(self.as_ref().to_glib_none().0))
        }
    }

    fn icon_theme_path(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_icon_theme_path(self.as_ref().to_glib_none().0))
        }
    }

    fn id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_id(self.as_ref().to_glib_none().0))
        }
    }

    fn label(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_label(self.as_ref().to_glib_none().0))
        }
    }

    fn label_guide(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_label_guide(self.as_ref().to_glib_none().0))
        }
    }

    fn menu(&self) -> Option<gtk::Menu> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_menu(self.as_ref().to_glib_none().0))
        }
    }

    fn ordering_index(&self) -> u32 {
        unsafe {
            ffi::app_indicator_get_ordering_index(self.as_ref().to_glib_none().0)
        }
    }

    fn secondary_activate_target(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_secondary_activate_target(self.as_ref().to_glib_none().0))
        }
    }

    fn status(&self) -> IndicatorStatus {
        unsafe {
            from_glib(ffi::app_indicator_get_status(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v0_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_5")))]
    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::app_indicator_get_title(self.as_ref().to_glib_none().0))
        }
    }

    fn set_attention_icon(&self, icon_name: &str) {
        unsafe {
            ffi::app_indicator_set_attention_icon(self.as_ref().to_glib_none().0, icon_name.to_glib_none().0);
        }
    }

    fn set_attention_icon_full(&self, icon_name: &str, icon_desc: &str) {
        unsafe {
            ffi::app_indicator_set_attention_icon_full(self.as_ref().to_glib_none().0, icon_name.to_glib_none().0, icon_desc.to_glib_none().0);
        }
    }

    fn set_icon(&self, icon_name: &str) {
        unsafe {
            ffi::app_indicator_set_icon(self.as_ref().to_glib_none().0, icon_name.to_glib_none().0);
        }
    }

    fn set_icon_full(&self, icon_name: &str, icon_desc: &str) {
        unsafe {
            ffi::app_indicator_set_icon_full(self.as_ref().to_glib_none().0, icon_name.to_glib_none().0, icon_desc.to_glib_none().0);
        }
    }

    fn set_icon_theme_path(&self, icon_theme_path: &str) {
        unsafe {
            ffi::app_indicator_set_icon_theme_path(self.as_ref().to_glib_none().0, icon_theme_path.to_glib_none().0);
        }
    }

    fn set_label(&self, label: &str, guide: &str) {
        unsafe {
            ffi::app_indicator_set_label(self.as_ref().to_glib_none().0, label.to_glib_none().0, guide.to_glib_none().0);
        }
    }

    fn set_menu(&self, menu: Option<&impl IsA<gtk::Menu>>) {
        unsafe {
            ffi::app_indicator_set_menu(self.as_ref().to_glib_none().0, menu.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn set_ordering_index(&self, ordering_index: u32) {
        unsafe {
            ffi::app_indicator_set_ordering_index(self.as_ref().to_glib_none().0, ordering_index);
        }
    }

    fn set_secondary_activate_target(&self, menuitem: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::app_indicator_set_secondary_activate_target(self.as_ref().to_glib_none().0, menuitem.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    fn set_status(&self, status: IndicatorStatus) {
        unsafe {
            ffi::app_indicator_set_status(self.as_ref().to_glib_none().0, status.into_glib());
        }
    }

    #[cfg(any(feature = "v0_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_5")))]
    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::app_indicator_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_attention_icon_desc(&self, attention_icon_desc: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"attention-icon-desc", &attention_icon_desc)
    }

    fn attention_icon_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "attention-icon-name")
    }

    fn set_attention_icon_name(&self, attention_icon_name: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"attention-icon-name", &attention_icon_name)
    }

    fn is_connected(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "connected")
    }

    fn set_icon_desc(&self, icon_desc: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"icon-desc", &icon_desc)
    }

    fn icon_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "icon-name")
    }

    fn set_icon_name(&self, icon_name: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"icon-name", &icon_name)
    }

    fn set_label_guide(&self, label_guide: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"label-guide", &label_guide)
    }

    fn get_property_title(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "title")
    }

    fn set_property_title(&self, title: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"title", &title)
    }

    fn connect_connection_changed<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn connection_changed_trampoline<P: IsA<Indicator>, F: Fn(&P, bool) + 'static>(this: *mut ffi::AppIndicator, arg1: glib::ffi::gboolean, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref(), from_glib(arg1))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"connection-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(connection_changed_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_new_attention_icon<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn new_attention_icon_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"new-attention-icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(new_attention_icon_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_new_icon<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn new_icon_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"new-icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(new_icon_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_new_icon_theme_path<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn new_icon_theme_path_trampoline<P: IsA<Indicator>, F: Fn(&P, &str) + 'static>(this: *mut ffi::AppIndicator, object: *mut libc::c_char, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref(), &glib::GString::from_glib_borrow(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"new-icon-theme-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(new_icon_theme_path_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_new_label<F: Fn(&Self, &str, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn new_label_trampoline<P: IsA<Indicator>, F: Fn(&P, &str, &str) + 'static>(this: *mut ffi::AppIndicator, object: *mut libc::c_char, p0: *mut libc::c_char, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref(), &glib::GString::from_glib_borrow(object), &glib::GString::from_glib_borrow(p0))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"new-label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(new_label_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_new_status<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn new_status_trampoline<P: IsA<Indicator>, F: Fn(&P, &str) + 'static>(this: *mut ffi::AppIndicator, arg1: *mut libc::c_char, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref(), &glib::GString::from_glib_borrow(arg1))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"new-status\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(new_status_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scroll_event<F: Fn(&Self, i32, gdk::ScrollDirection) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn scroll_event_trampoline<P: IsA<Indicator>, F: Fn(&P, i32, gdk::ScrollDirection) + 'static>(this: *mut ffi::AppIndicator, arg1: libc::c_int, arg2: libc::c_uint, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            let direction = match arg2 as i32 {
                gdk_sys::GDK_SCROLL_UP => gdk::ScrollDirection::Up,
                gdk_sys::GDK_SCROLL_DOWN => gdk::ScrollDirection::Down,
                gdk_sys::GDK_SCROLL_LEFT => gdk::ScrollDirection::Left,
                gdk_sys::GDK_SCROLL_RIGHT => gdk::ScrollDirection::Right,
                gdk_sys::GDK_SCROLL_SMOOTH => gdk::ScrollDirection::Smooth,
                arg2 => gdk::ScrollDirection::__Unknown(arg2),
            };
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref(), arg1, direction)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"scroll-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(scroll_event_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_attention_icon_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attention_icon_desc_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::attention-icon-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_attention_icon_desc_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_attention_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attention_icon_name_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::attention-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_attention_icon_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_connected_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_connected_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::connected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_connected_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_icon_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_desc_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::icon-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_icon_desc_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_icon_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_icon_theme_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_theme_path_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::icon-theme-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_icon_theme_path_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_label_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_label_guide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_guide_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::label-guide\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_label_guide_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_ordering_index_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ordering_index_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::ordering-index\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_ordering_index_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::status\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_status_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<Indicator>, F: Fn(&P) + 'static>(this: *mut ffi::AppIndicator, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Indicator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_title_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Indicator {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Indicator")
    }
}
