// This file was generated by gir (https://github.com/gtk-rs/gir)
// from /home/rene/git/gir-files
// DO NOT EDIT

use glib::translate::*;
use std::fmt;

/// The category provides grouping for the indicators so that
/// users can find indicators that are similar together.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AppIndicatorCategory")]
pub enum IndicatorCategory {
    /// The indicator is used to display the status of the application.
    #[doc(alias = "APP_INDICATOR_CATEGORY_APPLICATION_STATUS")]
    ApplicationStatus,
    /// The application is used for communication with other people.
    #[doc(alias = "APP_INDICATOR_CATEGORY_COMMUNICATIONS")]
    Communications,
    /// A system indicator relating to something in the user's system.
    #[doc(alias = "APP_INDICATOR_CATEGORY_SYSTEM_SERVICES")]
    SystemServices,
    /// An indicator relating to the user's hardware.
    #[doc(alias = "APP_INDICATOR_CATEGORY_HARDWARE")]
    Hardware,
    /// Something not defined in this enum, please don't use unless you really need it.
    #[doc(alias = "APP_INDICATOR_CATEGORY_OTHER")]
    Other,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for IndicatorCategory {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "IndicatorCategory::{}", match *self {
            Self::ApplicationStatus => "ApplicationStatus",
            Self::Communications => "Communications",
            Self::SystemServices => "SystemServices",
            Self::Hardware => "Hardware",
            Self::Other => "Other",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for IndicatorCategory {
    type GlibType = ffi::AppIndicatorCategory;

    fn into_glib(self) -> ffi::AppIndicatorCategory {
        match self {
            Self::ApplicationStatus => ffi::APP_INDICATOR_CATEGORY_APPLICATION_STATUS,
            Self::Communications => ffi::APP_INDICATOR_CATEGORY_COMMUNICATIONS,
            Self::SystemServices => ffi::APP_INDICATOR_CATEGORY_SYSTEM_SERVICES,
            Self::Hardware => ffi::APP_INDICATOR_CATEGORY_HARDWARE,
            Self::Other => ffi::APP_INDICATOR_CATEGORY_OTHER,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AppIndicatorCategory> for IndicatorCategory {
    unsafe fn from_glib(value: ffi::AppIndicatorCategory) -> Self {
        match value {
            ffi::APP_INDICATOR_CATEGORY_APPLICATION_STATUS => Self::ApplicationStatus,
            ffi::APP_INDICATOR_CATEGORY_COMMUNICATIONS => Self::Communications,
            ffi::APP_INDICATOR_CATEGORY_SYSTEM_SERVICES => Self::SystemServices,
            ffi::APP_INDICATOR_CATEGORY_HARDWARE => Self::Hardware,
            ffi::APP_INDICATOR_CATEGORY_OTHER => Self::Other,
            value => Self::__Unknown(value),
}
    }
}

/// These are the states that the indicator can be on in
/// the user's panel. The indicator by default starts
/// in the state [`Passive`][Self::Passive] and can be
/// shown by setting it to [`Active`][Self::Active].
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AppIndicatorStatus")]
pub enum IndicatorStatus {
    /// The indicator should not be shown to the user.
    #[doc(alias = "APP_INDICATOR_STATUS_PASSIVE")]
    Passive,
    /// The indicator should be shown in it's default state.
    #[doc(alias = "APP_INDICATOR_STATUS_ACTIVE")]
    Active,
    /// The indicator should show it's attention icon.
    #[doc(alias = "APP_INDICATOR_STATUS_ATTENTION")]
    Attention,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for IndicatorStatus {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "IndicatorStatus::{}", match *self {
            Self::Passive => "Passive",
            Self::Active => "Active",
            Self::Attention => "Attention",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for IndicatorStatus {
    type GlibType = ffi::AppIndicatorStatus;

    fn into_glib(self) -> ffi::AppIndicatorStatus {
        match self {
            Self::Passive => ffi::APP_INDICATOR_STATUS_PASSIVE,
            Self::Active => ffi::APP_INDICATOR_STATUS_ACTIVE,
            Self::Attention => ffi::APP_INDICATOR_STATUS_ATTENTION,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AppIndicatorStatus> for IndicatorStatus {
    unsafe fn from_glib(value: ffi::AppIndicatorStatus) -> Self {
        match value {
            ffi::APP_INDICATOR_STATUS_PASSIVE => Self::Passive,
            ffi::APP_INDICATOR_STATUS_ACTIVE => Self::Active,
            ffi::APP_INDICATOR_STATUS_ATTENTION => Self::Attention,
            value => Self::__Unknown(value),
}
    }
}

