use clap::Parser;
use std::fs;
use std::io;
mod generator;
mod processor;

#[derive(Parser, Debug)]
#[clap(about, version, author)]
struct Args {
    file: String,
    #[clap(short, long)]
    output: Option<String>,
}

fn main() -> io::Result<()> {
    let args = Args::parse();

    let in_file = args.file;
    let out_file: String;

    if let Some(of) = args.output {
        out_file = of;
    } else {
        out_file = format!("{}_out", in_file);
    }

    let tokens = processor::DocTokenList::from_file(in_file);
    let out_str = generator::generate_ansi(tokens);
    fs::write(out_file, out_str)?;

    Ok(())
}
