use crate::processor::{DocTokenList, DocTokenType};

/// Generates text from tokens using ansi escape sequences
pub fn generate_ansi(tokens: DocTokenList) -> String {
    // return string
    let mut rstr = String::new();

    let mut header_number = 0;

    // itterates over each token
    for token in tokens.0.iter() {
        let content = token.content.trim();
        let tty_tok = match token.token_type {
            DocTokenType::Title => format!(
                "\t\t\x1b[1m{} \x1b[0m\n\n",
                content
            ),

            DocTokenType::Author => format!(
                "\t\t\x1b[3m{} \x1b[0m\n",
                content
            ),

            DocTokenType::Date => format!(
                "\t\t\x1b[0m{} \n",
                content
            ),

            DocTokenType::Text => format!("{} ", content),

            DocTokenType::Newline => String::from("\n"),

            DocTokenType::NHeader => { 
                header_number += 1;
                format!(
                    "\t\x1b[1m{}. {}\x1b[0m\n",
                    header_number,
                    content
            )},

            DocTokenType::Header => format!(
                "\t\x1b[1m{}\x1b[0m\n",
                content
            ),

            DocTokenType::Bold => format!(
                "\x1b[1m{}\x1b[0m ",
                content
            ),

            DocTokenType::Italic => format!(
                "\x1b[3m{}\x1b[0m ",
                content,
            ),

            DocTokenType::BoldItalic => format!(
                "\x1b[1;3m{}\x1b[0m",
                content
            ),

            _ => String::from(""),
        };
        rstr.push_str(tty_tok.as_str());
    }

    rstr.push('\n');
    rstr
}
