use rand::Rng;
use std::cmp::Ordering;
use std::io;

fn main() {
    println!("Guess the number!");

    // Because secret_number is later compared to guess,
    // Rust infers that secret_number should be of type u32
    let secret_number = rand::thread_rng().gen_range(1..101);

    let mut attempts = 0;
    let limit = 10;

    loop {
        println!("Please input your guess.");

        // Declare a mutable variable named guess that's bound to a new string value
        // new() is an associated function bound to type String (similar to a static method in object-oriented languages)
        let mut guess = String::new();

        io::stdin()
            .read_line(&mut guess) // Result types are enums with two variants: Ok and Err
            .expect("Failed to read line");

        // Rust allows existing variables to be shadowed by new variables
        let guess: u32 = match guess.trim().parse() {
            Ok(num) => num,
            Err(_) => {
                println!("Invalid guess");
                continue;
            }
        };

        println!("You guessed: {}", guess);

        attempts += 1;

        // A match expression consists of arms that contain patterns
        // Match expressions are a useful way to ensure you handle all branches of execution that can occur
        match guess.cmp(&secret_number) {
            Ordering::Less => println!("Too small!"),
            Ordering::Greater => println!("Too big!"),
            Ordering::Equal => {
                println!("You won the game in {} attempts!", attempts);
                break;
            }
        }

        if attempts >= limit {
            println!("You exceeded the maximum number of attempts!");
            break;
        }
    }
}
