use crate::unit::Derived;
use crate::units;

pub const MINUTE: u32 = 1021968384;
pub const HOUR: u32 = 1021968385;
pub const DAY: u32 = 1021968387;
pub const WEEK: u32 = 1021968388;
pub const MONTH: u32 = 1021968389;
pub const YEAR: u32 = 1021972480;
pub const DECADE: u32 = 1021976576;
pub const CENTURY: u32 = 1021980672;
pub const MILLENIUM: u32 = 1021984768;
pub const TONNE: u32 = 2065028312;
pub const DALTON: u32 = 2505588576;
pub const LITRE: u32 = 470846370;
pub const CUBIC_CENTIMETER: u32 = 3010028704;
pub const GALLON: u32 = 470846371;
pub const PINT: u32 = 470846372;
pub const QUART: u32 = 470846373;
pub const CUP: u32 = 470846374;
pub const GILL: u32 = 470846375;
pub const FLUID_OUNCE: u32 = 470846376;
pub const TABLE_SPOON: u32 = 470846377;
pub const TEA_SPOON: u32 = 470846378;
pub const HECTARE: u32 = 3207462927;
pub const PERCH: u32 = 4048801938;
pub const ROOD: u32 = 542383331;
pub const ACRE: u32 = 3829888978;
pub const ACCELERATION: u32 = 2863985516;
pub const VELOCITY: u32 = 1205679580;
pub const GFORCE: u32 = 3089834321;
pub const NEWTON: u32 = 353022001;
pub const PASCAL: u32 = 3581253485;
pub const JOULE: u32 = 3766052723;
pub const BTU: u32 = 3481565844;
pub const ELECTRONVOLT: u32 = 8051841;
pub const WATT: u32 = 2843211920;
pub const COULOMB: u32 = 4118630549;
pub const VOLT: u32 = 658988256;
pub const FARAD: u32 = 3466881141;
pub const OHM: u32 = 1281889753;
pub const SIEMENS: u32 = 3631692201;
pub const WEBER: u32 = 1774873610;
pub const TESLA: u32 = 1930761383;
pub const HENRY: u32 = 4012288469;
pub const LUMEN: u32 = 898832578;
pub const LUX: u32 = 2908765805;
pub const BECQUEREL: u32 = 2082853468;
pub const GRAY: u32 = 1611201717;
pub const SIEVERT: u32 = 3440369467;
pub const KATAL: u32 = 2521157679;
pub const LIGHT_SPEED: u32 = 2390987750;
pub const KNOT: u32 = 3360971096;
pub const AU: u32 = 3348159317;
pub const FATHOM: u32 = 1356152752;
pub const CABLE: u32 = 3642302754;
pub const NAUTICAL_MILE: u32 = 3613916546;
pub const LINK: u32 = 2518177391;
pub const ROD: u32 = 2060832621;
pub const THOU: u32 = 3553165328;
pub const BARLEYCORN: u32 = 3553165344;
pub const INCH: u32 = 3553165312;
pub const HAND: u32 = 3553165360;
pub const FOOT: u32 = 3553165313;
pub const YARD: u32 = 3553165314;
pub const CHAIN: u32 = 3906701589;
pub const FURLONG: u32 = 3553165376;
pub const MILE: u32 = 3553165315;
pub const LEAGUE: u32 = 3553165316;
pub const GRAIN: u32 = 4096923961;
pub const DRACHM: u32 = 2740530060;
pub const OUNCE: u32 = 2084259802;
pub const POUND: u32 = 3762825782;
pub const STONE: u32 = 3358063885;
pub const QUARTER: u32 = 553023611;
pub const HUNDREDWEIGHT: u32 = 4185545088;
pub const TON: u32 = 3434832998;
pub const SLUG: u32 = 686486555;
pub const CELSIUS: u32 = 3728342790;
pub const FAHRENHEIT: u32 = 981617578;
pub const SPECIFIC_IMPULSE: u32 = 1147115270;

/// Match the given id to the corresponding derived unit
pub fn id_to_derived(id: u32) -> Option<Derived> {
    match id {
        1021968384 => Some(units::time::MINUTE),
        1021968385 => Some(units::time::HOUR),
        1021968387 => Some(units::time::DAY),
        1021968388 => Some(units::time::WEEK),
        1021968389 => Some(units::time::MONTH),
        1021972480 => Some(units::time::YEAR),
        1021976576 => Some(units::time::DECADE),
        1021980672 => Some(units::time::CENTURY),
        1021984768 => Some(units::time::MILLENIUM),
        2065028312 => Some(units::mass::TONNE),
        2505588576 => Some(units::mass::DALTON),
        470846370 => Some(units::volume::LITRE),
        3010028704 => Some(units::volume::CUBIC_CENTIMETER),
        470846371 => Some(units::volume::GALLON),
        470846372 => Some(units::volume::PINT),
        470846373 => Some(units::volume::QUART),
        470846374 => Some(units::volume::CUP),
        470846375 => Some(units::volume::GILL),
        470846376 => Some(units::volume::FLUID_OUNCE),
        470846377 => Some(units::volume::TABLE_SPOON),
        470846378 => Some(units::volume::TEA_SPOON),
        3207462927 => Some(units::area::HECTARE),
        4048801938 => Some(units::area::PERCH),
        542383331 => Some(units::area::ROOD),
        3829888978 => Some(units::area::ACRE),
        2863985516 => Some(units::ACCELERATION),
        1205679580 => Some(units::VELOCITY),
        3089834321 => Some(units::GFORCE),
        353022001 => Some(units::NEWTON),
        3581253485 => Some(units::PASCAL),
        3766052723 => Some(units::energy::JOULE),
        3481565844 => Some(units::energy::BTU),
        8051841 => Some(units::energy::ELECTRONVOLT),
        2843211920 => Some(units::WATT),
        4118630549 => Some(units::COULOMB),
        658988256 => Some(units::VOLT),
        3466881141 => Some(units::FARAD),
        1281889753 => Some(units::OHM),
        3631692201 => Some(units::SIEMENS),
        1774873610 => Some(units::WEBER),
        1930761383 => Some(units::TESLA),
        4012288469 => Some(units::HENRY),
        898832578 => Some(units::LUMEN),
        2908765805 => Some(units::LUX),
        2082853468 => Some(units::BECQUEREL),
        1611201717 => Some(units::GRAY),
        3440369467 => Some(units::SIEVERT),
        2521157679 => Some(units::KATAL),
        2390987750 => Some(units::velocity::LIGHT_SPEED),
        3360971096 => Some(units::velocity::KNOT),
        3348159317 => Some(units::length::AU),
        1356152752 => Some(units::length::FATHOM),
        3642302754 => Some(units::length::CABLE),
        3613916546 => Some(units::length::NAUTICAL_MILE),
        2518177391 => Some(units::length::LINK),
        2060832621 => Some(units::length::ROD),
        3553165328 => Some(units::length::THOU),
        3553165344 => Some(units::length::BARLEYCORN),
        3553165312 => Some(units::length::INCH),
        3553165360 => Some(units::length::HAND),
        3553165313 => Some(units::length::FOOT),
        3553165314 => Some(units::length::YARD),
        3906701589 => Some(units::length::CHAIN),
        3553165376 => Some(units::length::FURLONG),
        3553165315 => Some(units::length::MILE),
        3553165316 => Some(units::length::LEAGUE),
        4096923961 => Some(units::mass::GRAIN),
        2740530060 => Some(units::mass::DRACHM),
        2084259802 => Some(units::mass::OUNCE),
        3762825782 => Some(units::mass::POUND),
        3358063885 => Some(units::mass::STONE),
        553023611 => Some(units::mass::QUARTER),
        4185545088 => Some(units::mass::HUNDREDWEIGHT),
        3434832998 => Some(units::mass::TON),
        686486555 => Some(units::mass::SLUG),
        3728342790 => Some(units::temperature::CELSIUS),
        981617578 => Some(units::temperature::FAHRENHEIT),
        1147115270 => Some(units::SPECIFIC_IMPULSE),
        _ => None,
    }
}
