#![cfg(target_arch = "x86_64")]

#[cfg(target_os = "windows")]
mod windows;
#[cfg(target_os = "windows")]
pub use windows::*;

#[cfg(target_os = "linux")]
mod linux;
#[cfg(target_os = "linux")]
pub use linux::*;

use std::fmt;
use std::time::Instant;

pub struct ElapsedMilliseconds {
    initial_instant: Instant,
}

impl crate::ElapsedMilliseconds for ElapsedMilliseconds {
    fn start() -> Self {
        Self {
            initial_instant: Instant::now(),
        }
    }
    fn elapsed(&self) -> u128 {
        self.initial_instant.elapsed().as_millis()
    }
}

impl fmt::Debug for super::DebuggerError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        #[cfg(not(debug_assertions))]
        return write!(f, "{}", obfstr::obfstr!("Something went wrong"));
        #[cfg(debug_assertions)]
        match self {
            super::DebuggerError::InstructionNotAvailable => {
                write!(f, "Can not use debugger instruction")
            }
            super::DebuggerError::TamperedEnvironment => {
                write!(f, "Debugger behavior is not as expected, maybe it was modified to analyze this")
            }
        }
    }
}

pub(crate) fn debugger_instruction() -> Result<(), super::DebuggerError> {
    Err(super::DebuggerError::InstructionNotAvailable)
}
