//! Common API without platform details.

#[cfg(target_arch = "x86_64")]
mod x86_64;
#[cfg(target_arch = "x86_64")]
pub use x86_64::*;

#[cfg(target_arch = "wasm32")]
mod wasm;
#[cfg(target_arch = "wasm32")]
pub use wasm::*;

use std::error::Error;
use std::fmt;

#[allow(dead_code)] // Not all errors variations
pub enum DebuggerError {
    InstructionNotAvailable,
    TamperedEnvironment,
}

impl fmt::Display for DebuggerError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        fmt::Debug::fmt(self, f)
    }
}

impl Error for DebuggerError {}
