mod platform;

trait ElapsedMilliseconds {
    fn start() -> Self;
    fn elapsed(&self) -> u128;
}

// NOTE: To duplicate the check and make difficult to edit all checks at onece inline always will be used.

#[allow(unused_must_use)]
#[inline(always)]
pub fn is_ok_debugger_instruction_timing() -> bool {
    let timer_millis = platform::ElapsedMilliseconds::start();
    platform::debugger_instruction();
    return timer_millis.elapsed() < 100;
}

#[inline(always)]
pub fn is_debugger_present() -> bool {
    return platform::is_debugger_present();
}
