use fltk::prelude::*;

#[derive (thiserror::Error, Debug)]
pub enum Error {
	#[error ("46MVLSEL Cannot parse argument: {0}")]
	CannotParseArg (&'static str),
	#[error ("4JZ5B2FN Editor has no buffer, this should be impossible")]
	EditorHasNoBuffer,
	#[error ("OKE7Z5O6 FLTK: {0}")]
	Fltk (#[from] FltkError),
	#[error ("4BQPBIAJ IO")]
	Io (#[from] std::io::Error),
	#[error ("KDP4DNOP JSON serialization failed")]
	JsonSerialization (#[from] serde_json::Error),
	#[error ("3MYHBQWV Parameter {0} needs an argument")]
	ParamNeedsArg (&'static str),
}
